/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.pager.NextPreviousPager;
import com.atlassian.jira.issue.pager.PagerManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collection;

public class ManageAttachments
extends AbstractCommentableIssue {
    private static final String ATTACH_FILE_ISSUE_OPERATION_KEY = "com.atlassian.jira.plugin.system.issueoperations:attach-file";
    private static final String ATTACH_SCREENSHOT_ISSUE_OPERATION_KEY = "com.atlassian.jira.plugin.system.issueoperations:attach-screenshot";
    private final AttachmentService attachmentService;
    private final PluginAccessor pluginAccessor;
    private final PagerManager pagerManager;
    Collection affectedVersions;
    Collection components;
    Collection fixVersions;
    private Issue parentIssueObject = null;

    public ManageAttachments(SubTaskManager subTaskManager, AttachmentService attachmentService, PluginAccessor pluginAccessor, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, PagerManager pagerManager, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.attachmentService = attachmentService;
        this.pluginAccessor = pluginAccessor;
        this.pagerManager = pagerManager;
    }

    @Override
    protected void doValidation() {
    }

    protected String doExecute() throws Exception {
        MutableIssue issue;
        try {
            issue = this.getIssueObject();
        }
        catch (IssueNotFoundException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.issue.does.not.exist"));
            return "issuenotfound";
        }
        catch (IssuePermissionException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.no.browse.permission"));
            return "permissionviolation";
        }
        NextPreviousPager pager = this.getNextPreviousPager();
        if (pager != null) {
            pager.update(this.getSearchRequest(), this.getLoggedInUser(), issue == null ? null : issue.getKey());
        }
        return super.doExecute();
    }

    public boolean isScreenshotAttachable() {
        return this.isIssueOperationShowable(ATTACH_SCREENSHOT_ISSUE_OPERATION_KEY) && this.attachmentService.canAttachScreenshots(this.getJiraServiceContext(), (Issue)this.getIssueObject());
    }

    public boolean isAttachable() {
        return this.isIssueOperationShowable(ATTACH_FILE_ISSUE_OPERATION_KEY) && this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), (Issue)this.getIssueObject());
    }

    public Collection getComponents() throws Exception {
        if (this.getIssueObject() != null && this.components == null) {
            this.components = this.getIssueObject().getComponents();
        }
        return this.components;
    }

    public Collection getAffectedVersions() throws Exception {
        if (this.getIssueObject() != null && this.affectedVersions == null) {
            this.affectedVersions = new ArrayList();
            for (Version version : this.getIssueObject().getAffectedVersions()) {
                this.affectedVersions.add(version.getGenericValue());
            }
        }
        return this.affectedVersions;
    }

    public Collection getFixVersions() throws Exception {
        if (this.getIssueObject() != null && this.fixVersions == null) {
            this.fixVersions = new ArrayList();
            for (Version version : this.getIssueObject().getFixVersions()) {
                this.fixVersions.add(version.getGenericValue());
            }
        }
        return this.fixVersions;
    }

    public boolean isHasDeleteAttachmentPermission(Long attachmentId) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection());
        return this.attachmentService.canDeleteAttachment((JiraServiceContext)context, attachmentId);
    }

    @Override
    public Issue getParentIssueObject() {
        MutableIssue issue;
        if (this.isSubTask() && this.parentIssueObject == null && (issue = this.getIssueObject()) != null && issue.isSubTask() && issue.getParentObject() != null) {
            this.parentIssueObject = issue.getParentObject();
        }
        return this.parentIssueObject;
    }

    public NextPreviousPager getNextPreviousPager() {
        return this.pagerManager.getPager();
    }

    private boolean isIssueOperationShowable(String issueOperationKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(issueOperationKey);
        return moduleDescriptor != null;
    }

    public boolean getZipSupport() {
        return this.getApplicationProperties().getOption("jira.attachment.allow.zip.support");
    }
}

