/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.vcs;

import alt.java.io.File;
import alt.java.io.FileImpl;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.LockException;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CvsRepository;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.vcs.cvsimpl.ValidationException;
import com.atlassian.jira.web.action.admin.vcs.RepositoryActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.IOException;
import net.sf.statcvs.input.LogSyntaxException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class RepositoryTest
extends RepositoryActionSupport {
    private String message;

    public RepositoryTest(RepositoryManager repositoryManager, CvsRepositoryUtil cvsRepositoryUtil) {
        super(repositoryManager, cvsRepositoryUtil);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.getId() == null) {
            this.message = "Please specifiy a Repository to test.";
        } else {
            Repository repository = null;
            try {
                repository = this.getRepositoryManager().getRepository(this.getId());
                if (repository == null) {
                    this.message = "Could not retrieve repository with id '" + this.getId() + "'.";
                    return this.getResult();
                }
            }
            catch (GenericEntityException e) {
                this.message = "Error occurred while retrieving repository with id '" + this.getId() + "'.";
                return this.getResult();
            }
            if ("cvs".equals(repository.getType())) {
                CvsRepository cvsRepository = (CvsRepository)repository;
                try {
                    this.getCvsRepositoryUtil().checkLogFilePath((File)new FileImpl(cvsRepository.getCvsLogFilePath()), cvsRepository.fetchLog());
                    this.getCvsRepositoryUtil().checkCvsRoot(cvsRepository.getCvsRoot());
                }
                catch (ValidationException e) {
                    this.message = "Problem with repository\n" + ExceptionUtils.getStackTrace((Throwable)e);
                    return this.getResult();
                }
                try {
                    this.testRepository(cvsRepository.getName(), cvsRepository.getCvsLogFilePath(), cvsRepository.getCvsRoot(), cvsRepository.getModuleName(), cvsRepository.getPassword(), cvsRepository.getCvsTimeout(), cvsRepository.fetchLog());
                }
                catch (AuthenticationException e) {
                    String errorMessage = "Error authenticating with the repository.";
                    this.log.error((Object)"Error authenticating with the repository.", (Throwable)e);
                    Throwable cause = e.getUnderlyingThrowable();
                    if (cause != null) {
                        this.log.error((Object)("Caused by: " + cause.getMessage()), cause);
                    }
                    this.message = "Error authenticating with the repository.\n" + ExceptionUtils.getStackTrace((Throwable)e) + (cause != null ? "\n" + ExceptionUtils.getStackTrace((Throwable)cause) : "");
                }
                catch (LogSyntaxException e) {
                    String errorMessage = "Error while parsing cvs log.";
                    this.log.error((Object)"Error while parsing cvs log.", (Throwable)e);
                    this.message = "Error while parsing cvs log.\n" + ExceptionUtils.getStackTrace((Throwable)e);
                }
                catch (LockException e) {
                    String errorMessage = "Error obtaining lock.";
                    this.log.error((Object)"Error obtaining lock.", (Throwable)e);
                    this.message = "Error obtaining lock.\n" + ExceptionUtils.getStackTrace((Throwable)e);
                }
                catch (IOException e) {
                    String errorMessage = e.getMessage();
                    this.log.error((Object)errorMessage, (Throwable)e);
                    this.message = errorMessage + "\n" + ExceptionUtils.getStackTrace((Throwable)e);
                }
                catch (CommandException e) {
                    String errorMessage = "Error occured while retrieving cvs log.";
                    this.log.error((Object)"Error occured while retrieving cvs log.", (Throwable)e);
                    this.message = "Error occured while retrieving cvs log.\n" + ExceptionUtils.getStackTrace((Throwable)e);
                }
                catch (Throwable t) {
                    String errorMEssage = "Error occurred while obtaining cvs or parsing the cvs log.";
                    this.log.error((Object)"Error occurred while obtaining cvs or parsing the cvs log.", t);
                    this.message = "Error occurred while obtaining cvs or parsing the cvs log.\n" + ExceptionUtils.getStackTrace((Throwable)t);
                }
                if (this.message != null) {
                    return this.getResult();
                }
            } else {
                this.message = "Unknown repository type.";
            }
        }
        return super.doExecute();
    }

    public String getMessage() {
        return this.message;
    }
}

