/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.SchemeAware;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSchemeAware
extends JiraWebActionSupport
implements SchemeAware {
    private Long schemeId;

    protected void doValidation() {
        if (this.getSchemeId() != null) {
            try {
                FieldLayoutScheme fieldLayoutScheme = this.getFieldLayoutScheme();
                if (fieldLayoutScheme == null) {
                    this.addErrorMessage(this.getInvalidSchemeId());
                }
            }
            catch (DataAccessException e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage("Could not retrieve the Field Layout Scheme.");
            }
        } else {
            this.addErrorMessage(this.getInvalidSchemeId());
        }
    }

    @Override
    public Long getSchemeId() {
        return this.schemeId;
    }

    @Override
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    @Override
    public GenericValue getScheme() {
        throw new UnsupportedOperationException("Use getFieldLayoutScheme() instead.");
    }

    public FieldLayoutScheme getFieldLayoutScheme() {
        return this.getFieldLayoutManager().getMutableFieldLayoutScheme(this.getSchemeId());
    }

    public FieldLayoutManager getFieldLayoutManager() {
        return ComponentAccessor.getFieldManager().getFieldLayoutManager();
    }
}

