/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.customfields.AbstractEditConfigurationItemAction;
import com.atlassian.jira.web.action.admin.customfields.EditCustomFieldDefaults;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditCustomFieldOptions
extends AbstractEditConfigurationItemAction {
    private String addValue;
    private String value;
    private String selectedValue;
    private boolean confirm;
    private Collection hlFields;
    private Long selectedParentOptionId;
    private Map customFieldValuesHolder = new HashMap();
    private Options options;
    private Object defaultValues;
    private final ReindexMessageManager reindexMessageManager;
    private static final String NEW_OPTION_POSITION_PREFIX = "newOptionPosition_";
    private final IssueManager issueManager;

    public EditCustomFieldOptions(IssueManager issueManager, ReindexMessageManager reindexMessageManager) {
        this.issueManager = issueManager;
        this.reindexMessageManager = reindexMessageManager;
        this.hlFields = new LinkedList();
    }

    public String doDefault() throws Exception {
        this.setReturnUrl(null);
        if (!(this.getCustomField().getCustomFieldType() instanceof MultipleSettableCustomFieldType)) {
            this.addErrorMessage(this.getText("admin.errors.customfields.cannot.set.options", "'" + this.getCustomField().getCustomFieldType().getName() + "'"));
        }
        EditCustomFieldDefaults.populateDefaults(this.getFieldConfig(), this.customFieldValuesHolder);
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getCustomField() == null) {
            this.addErrorMessage(this.getText("admin.errors.customfields.no.field.selected.for.edit"));
        }
    }

    @RequiresXsrfCheck
    public String doConfigureOption() {
        Map parameters = ActionContext.getParameters();
        if (parameters.containsKey("moveOptionsToPosition")) {
            return this.changeOptionPositions(parameters);
        }
        throw new IllegalStateException("Unknown operation.");
    }

    private String changeOptionPositions(Map parameters) {
        TreeMap<Integer, Option> optionPositions = new TreeMap<Integer, Option>();
        for (String paramName : parameters.keySet()) {
            if (!paramName.startsWith(NEW_OPTION_POSITION_PREFIX) || !TextUtils.stringSet((String)this.getTextValueFromParams(paramName))) continue;
            String fieldId = paramName.substring(NEW_OPTION_POSITION_PREFIX.length());
            Integer newOptionPosition = null;
            try {
                newOptionPosition = Integer.valueOf(this.getTextValueFromParams(paramName));
                Integer newIndex = new Integer(newOptionPosition - 1);
                if (newOptionPosition <= 0 || newOptionPosition > this.getDisplayOptions().size()) {
                    this.addError(paramName, this.getText("admin.errors.invalid.position"));
                    continue;
                }
                if (optionPositions.containsKey(newIndex)) {
                    this.addError(paramName, this.getText("admin.errors.invalid.position"));
                    continue;
                }
                optionPositions.put(newIndex, this.getOptions().getOptionById(Long.decode(fieldId)));
            }
            catch (NumberFormatException e) {
                this.addError(paramName, this.getText("admin.errors.invalid.position"));
            }
        }
        if (!this.invalidInput()) {
            this.getOptions().moveOptionToPosition(optionPositions);
            Iterator<Object> iterator = optionPositions.values().iterator();
            while (iterator.hasNext()) {
                this.populateHlField((Option)iterator.next());
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    private String redirectToView() {
        StringBuilder redirectUrl = new StringBuilder("EditCustomFieldOptions!default.jspa?fieldConfigId=").append(this.getFieldConfigId());
        if (this.getSelectedParentOptionId() != null) {
            redirectUrl.append("&selectedParentOptionId=" + this.getSelectedParentOptionId());
        }
        Iterator iterator = this.hlFields.iterator();
        while (iterator.hasNext()) {
            redirectUrl.append("&currentOptions=").append(this.urlEncode((String)iterator.next()));
        }
        return this.getRedirect(redirectUrl.toString());
    }

    private String getTextValueFromParams(String newPositionFieldName) {
        String[] newFieldPositionArray = (String[])ActionContext.getParameters().get(newPositionFieldName);
        if (newFieldPositionArray != null && newFieldPositionArray.length > 0) {
            return newFieldPositionArray[0];
        }
        return "";
    }

    @RequiresXsrfCheck
    public String doAdd() throws Exception {
        this.doValidation();
        if (!TextUtils.stringSet((String)this.addValue)) {
            this.addError("addValue", this.getText("admin.errors.customfields.invalid.select.list.value"));
        }
        if (this.invalidInput()) {
            return this.getResult();
        }
        Options options = this.getOptions();
        if (options.getOptionForValue(this.getAddValue(), this.getSelectedParentOptionId()) != null) {
            this.addError("addValue", this.getText("admin.errors.customfields.value.already.exists"));
            return "error";
        }
        options.addOption(options.getOptionById(this.getSelectedParentOptionId()), this.getAddValue());
        if (!this.getDisplayOptions().isEmpty()) {
            this.hlFields.add(this.getAddValue());
        }
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    public String doSort() throws Exception {
        this.getOptions().sortOptionsByValue(this.getSelectedParentOption());
        return this.getRedirect(this.getRedirectUrl());
    }

    @RequiresXsrfCheck
    public String doMoveToFirst() throws Exception {
        this.populateHlField(this.getSelectedOption());
        this.getOptions().moveToStartSequence(this.getSelectedOption());
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    public String doMoveUp() throws Exception {
        this.populateHlField(this.getSelectedOption());
        this.getOptions().decrementSequence(this.getSelectedOption());
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    public String doMoveDown() throws Exception {
        this.populateHlField(this.getSelectedOption());
        this.getOptions().incrementSequence(this.getSelectedOption());
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    public String doMoveToLast() throws Exception {
        this.populateHlField(this.getSelectedOption());
        this.getOptions().moveToLastSequence(this.getSelectedOption());
        return this.redirectToView();
    }

    private void populateHlField(Option option) {
        this.hlFields.add(option.getValue());
    }

    public String getNewPositionTextBoxName(int optionId) {
        return NEW_OPTION_POSITION_PREFIX + optionId;
    }

    public String getNewPositionValue(int optionId) {
        return this.getTextValueFromParams(this.getNewPositionTextBoxName(optionId));
    }

    @RequiresXsrfCheck
    public String doRemove() throws Exception {
        if (!this.confirm) {
            return "confirmdelete";
        }
        this.removeValuesFromIssues();
        this.getOptions().removeOption(this.getSelectedOption());
        return this.getRedirect(this.getRedirectUrl());
    }

    @RequiresXsrfCheck
    public String doDisable() throws Exception {
        this.getOptions().disableOption(this.getSelectedOption());
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    public String doEnable() throws Exception {
        this.getOptions().enableOption(this.getSelectedOption());
        return this.redirectToView();
    }

    public String doEdit() throws Exception {
        this.setValue(this.getSelectedOption().getValue());
        return "edit";
    }

    @RequiresXsrfCheck
    public String doUpdate() throws Exception {
        if (!TextUtils.stringSet((String)this.value)) {
            this.addError("value", this.getText("admin.errors.customfields.invalid.select.list.value"));
            return "edit";
        }
        Options options = this.getOptions();
        Option duplicateOption = options.getOptionForValue(this.value, this.getSelectedParentOptionId());
        if (duplicateOption != null && !this.getSelectedOption().getOptionId().equals(duplicateOption.getOptionId())) {
            this.addError("value", this.getText("admin.errors.customfields.value.already.exists"));
            return "edit";
        }
        this.getOptions().setValue(this.getSelectedOption(), this.value);
        return this.getRedirect(this.getRedirectUrl());
    }

    protected String doExecute() throws Exception {
        return "input";
    }

    private void removeValuesFromIssues() {
        Collection issues = this.getAffectedIssues();
        for (Issue issue : issues) {
            MultipleSettableCustomFieldType customFieldType = (MultipleSettableCustomFieldType)this.getCustomField().getCustomFieldType();
            customFieldType.removeValue(this.getCustomField(), issue, this.getSelectedOption());
        }
        this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.custom.fields");
    }

    public Collection getAffectedIssues() {
        MultipleSettableCustomFieldType customFieldType = (MultipleSettableCustomFieldType)this.getCustomField().getCustomFieldType();
        Set ids = customFieldType.getIssueIdsWithValue(this.getCustomField(), this.getSelectedOption());
        ArrayList<MutableIssue> issues = new ArrayList<MutableIssue>(ids.size());
        for (Long id : ids) {
            MutableIssue issue = this.issueManager.getIssueObject(id);
            FieldConfig relevantConfigFromGv = this.getCustomField().getRelevantConfig((Issue)issue);
            if (!this.getFieldConfig().equals(relevantConfigFromGv)) continue;
            issues.add(issue);
        }
        return issues;
    }

    public Options getOptions() {
        if (this.options == null) {
            Long selectedParentOptionId = this.getSelectedParentOptionId();
            this.options = this.getCustomField().getOptions(selectedParentOptionId != null ? selectedParentOptionId.toString() : null, this.getFieldConfig(), null);
        }
        return this.options;
    }

    public Collection getDisplayOptions() {
        Options options = this.getOptions();
        Option parentOption = options.getOptionById(this.getSelectedParentOptionId());
        if (parentOption != null) {
            return parentOption.getChildOptions();
        }
        return options;
    }

    public Option getSelectedOption() {
        return this.getOptions().getOptionById(OptionUtils.safeParseLong((String)this.getSelectedValue()));
    }

    public Option getSelectedParentOption() {
        return this.getOptions().getOptionById(this.getSelectedParentOptionId());
    }

    public Object getDefaultValues() {
        if (this.defaultValues == null) {
            Object dbDefaultValues = this.getCustomField().getCustomFieldType().getDefaultValue(this.getFieldConfig());
            if (dbDefaultValues instanceof String) {
                ArrayList<Object> tempCollection = new ArrayList<Object>(1);
                tempCollection.add(dbDefaultValues);
                this.defaultValues = tempCollection;
            } else {
                this.defaultValues = dbDefaultValues;
            }
        }
        return this.defaultValues;
    }

    public boolean isDefaultValue(String value) {
        Object defaults = this.getDefaultValues();
        if (defaults instanceof Collection) {
            Collection defCollection = (Collection)defaults;
            Option option = this.options.getOptionById(OptionUtils.safeParseLong((String)value));
            if (option != null) {
                return defCollection.contains(option.getValue());
            }
            return false;
        }
        if (defaults instanceof CustomFieldParams) {
            CustomFieldParams fieldParams = (CustomFieldParams)defaults;
            Collection allFieldValues = fieldParams.getAllValues();
            for (Object defaultOptionId : allFieldValues) {
                Option option;
                if (value != null && value.equals(defaultOptionId)) {
                    return true;
                }
                if (!(defaultOptionId instanceof Option) || !(option = (Option)defaultOptionId).getOptionId().toString().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public int getButtonRowSize() {
        int rowSize = 2;
        if (this.getDisplayOptions().size() > 1) {
            ++rowSize;
        }
        return rowSize;
    }

    public boolean isCascadingSelect() {
        return this.getCustomField().getCustomFieldType() instanceof CascadingSelectCFType;
    }

    private String getRedirectUrl() {
        if (this.getSelectedParentOptionId() == null) {
            return this.getBaseUrl();
        }
        return this.getUrlWithParent("default");
    }

    private String getBaseUrl() {
        return this.getBaseUrl("default");
    }

    private String getBaseUrl(String action) {
        return "EditCustomFieldOptions!" + action + ".jspa?fieldConfigId=" + this.getFieldConfig().getId() + "&atl_token=" + this.urlEncode(this.getXsrfToken());
    }

    public String getSelectedParentOptionUrlPreifx() {
        return this.getBaseUrl() + "&selectedParentOptionId=";
    }

    public String getSelectedParentOptionUrlPrefix(String action) {
        return this.getBaseUrl(action) + "&selectedParentOptionId=";
    }

    public String getDoActionUrl(Option option, String action) {
        return this.getUrlWithParent(action) + "&selectedValue=" + (option != null ? option.getOptionId().toString() : "");
    }

    public String getUrlWithParent(String action) {
        if (this.getSelectedParentOptionId() == null) {
            return this.getBaseUrl(action);
        }
        return this.getBaseUrl(action) + "&selectedParentOptionId=" + this.getSelectedParentOptionId();
    }

    public String getAddValue() {
        return this.addValue;
    }

    public void setAddValue(String addValue) {
        this.addValue = addValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public Long getSelectedParentOptionId() {
        return this.selectedParentOptionId;
    }

    public void setSelectedParentOptionId(Long selectedParentOptionId) {
        this.selectedParentOptionId = selectedParentOptionId;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Collection getHlOptions() {
        return this.hlFields;
    }

    public void setCurrentOptions(String[] currentFields) {
        this.hlFields = Arrays.asList(currentFields);
    }
}

