/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.util;

import com.atlassian.core.ofbiz.CoreFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class Sequences {
    public void update(Connection connection, String sequenceName, String tableName) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("select max(id) from " + this.convertToSchemaTableName(tableName));
        ResultSet rs = stmt.executeQuery();
        rs.next();
        int maxId = rs.getInt(1);
        rs.close();
        stmt.close();
        stmt = connection.prepareStatement("select count(*) from " + this.convertToSchemaTableName("SEQUENCE_VALUE_ITEM") + " where seq_name = ?");
        stmt.setString(1, sequenceName);
        rs = stmt.executeQuery();
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        stmt.close();
        int id = maxId + 10;
        id -= id % 10;
        if (count == 0) {
            stmt = connection.prepareStatement("insert into " + this.convertToSchemaTableName("SEQUENCE_VALUE_ITEM") + " (seq_name, seq_id) values(?, ?)");
            stmt.setString(1, sequenceName);
            stmt.setInt(2, id);
            stmt.execute();
            stmt.close();
        } else {
            stmt = connection.prepareStatement("update " + this.convertToSchemaTableName("SEQUENCE_VALUE_ITEM") + " set seq_id = ? where seq_name = ?");
            stmt.setInt(1, id);
            stmt.setString(2, sequenceName);
            stmt.execute();
            stmt.close();
        }
    }

    protected GenericDelegator getDelegator() {
        return CoreFactory.getGenericDelegator();
    }

    protected String convertToSchemaTableName(String tableName) {
        GenericHelper helper;
        try {
            helper = this.getDelegator().getEntityHelper("User");
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helper.getHelperName());
        String schemaName = datasourceInfo.getSchemaName();
        if (schemaName != null && schemaName.length() > 0 && !tableName.startsWith(schemaName)) {
            return schemaName + "." + tableName;
        }
        return tableName;
    }
}

