/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.upgrade.tasks.jql.AbsoluteDateXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.AffectedVersionClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.CascadeSelectParameterClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandlerRegistry;
import com.atlassian.jira.upgrade.tasks.jql.ComponentClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ConstantsClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.FixForVersionClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.MultiValueParameterClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ProjectClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.RelativeDateXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.SimpleCustomFieldClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.StringRangeParameterClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.TextSystemFieldClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.UserClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.UserGroupParameterCustomFieldClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.UserParameterCustomFieldClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.WorkRatioClauseXmlHandler;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultClauseXmlHandlerRegistry
implements ClauseXmlHandlerRegistry {
    private static final Logger log = Logger.getLogger(DefaultClauseXmlHandlerRegistry.class);
    private final Map<String, ClauseXmlHandler> handlers;
    private final CustomFieldManager customFieldManager;

    public DefaultClauseXmlHandlerRegistry(CustomFieldManager customFieldManager, JqlSelectOptionsUtil jqlSelectOptionsUtil, FieldFlagOperandRegistry fieldFlagOperandRegistry, TimeZoneManager timeZoneManager) {
        this(customFieldManager, MapBuilder.newBuilder().add((Object)"com.atlassian.jira.issue.search.parameters.lucene.PriorityParameter", (Object)new ConstantsClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.ResolutionParameter", (Object)new ConstantsClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.StatusParameter", (Object)new ConstantsClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.IssueTypeParameter", (Object)new ConstantsClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.IssueConstantsParameter", (Object)new ConstantsClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.ProjectParameter", (Object)new ProjectClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.VersionParameter", (Object)new AffectedVersionClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.FixForParameter", (Object)new FixForVersionClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.ComponentParameter", (Object)new ComponentClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.MultipleFieldSingleValueLuceneParameter", (Object)new TextSystemFieldClauseXmlHandler(fieldFlagOperandRegistry)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.AbsoluteDateRangeParameter:created", (Object)new AbsoluteDateXmlHandler(Collections.singletonList("created"), timeZoneManager)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.AbsoluteDateRangeParameter:updated", (Object)new AbsoluteDateXmlHandler(Collections.singletonList("updated"), timeZoneManager)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.AbsoluteDateRangeParameter:duedate", (Object)new AbsoluteDateXmlHandler(Collections.singletonList("duedate"), timeZoneManager)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.AbsoluteDateRangeParameter:resolutiondate", (Object)new AbsoluteDateXmlHandler(Collections.singletonList("resolutiondate"), timeZoneManager)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.RelativeDateRangeParameter:created", (Object)new RelativeDateXmlHandler(Collections.singletonList("created"))).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.RelativeDateRangeParameter:updated", (Object)new RelativeDateXmlHandler(Collections.singletonList("updated"))).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.RelativeDateRangeParameter:duedate", (Object)new RelativeDateXmlHandler(Collections.singletonList("duedate"))).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.RelativeDateRangeParameter:resolutiondate", (Object)new RelativeDateXmlHandler(Collections.singletonList("resolutiondate"))).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.UserParameter:issue_author", (Object)new UserClauseXmlHandler(SystemSearchConstants.forReporter())).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.UsersGroupParameter:issue_author_group", (Object)new UserClauseXmlHandler(SystemSearchConstants.forReporter())).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.UserParameter:issue_assignee", (Object)new UserClauseXmlHandler(SystemSearchConstants.forAssignee())).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.UsersGroupParameter:issue_assignee_group", (Object)new UserClauseXmlHandler(SystemSearchConstants.forAssignee())).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.WorkRatioParameter", (Object)new WorkRatioClauseXmlHandler()).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.GenericMultiValueParameter", (Object)new MultiValueParameterClauseXmlHandler(fieldFlagOperandRegistry, customFieldManager)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.AbsoluteDateRangeParameter", (Object)new AbsoluteDateXmlHandler(Collections.<String>emptyList(), timeZoneManager)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.RelativeDateRangeParameter", (Object)new RelativeDateXmlHandler(Collections.<String>emptyList())).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.StringParameter", (Object)new SimpleCustomFieldClauseXmlHandler("value", Operator.EQUALS)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.FreeTextParameter", (Object)new SimpleCustomFieldClauseXmlHandler("value", Operator.LIKE)).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.UserParameter", (Object)new UserParameterCustomFieldClauseXmlHandler()).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.UsersGroupParameter", (Object)new UserGroupParameterCustomFieldClauseXmlHandler()).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.StringRangeParameter", (Object)new StringRangeParameterClauseXmlHandler()).add((Object)"com.atlassian.jira.issue.search.parameters.lucene.StringParameter:com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", (Object)new CascadeSelectParameterClauseXmlHandler(jqlSelectOptionsUtil)).toMap());
    }

    DefaultClauseXmlHandlerRegistry(CustomFieldManager customFieldManager, Map<String, ClauseXmlHandler> handlers) {
        this.handlers = handlers;
        this.customFieldManager = (CustomFieldManager)Assertions.notNull((String)"customFieldManager", (Object)customFieldManager);
    }

    @Override
    public ClauseXmlHandler getClauseXmlHandler(String searchParameterClassName, String elementName) {
        Assertions.notBlank((String)"elementName", (String)elementName);
        if (elementName.startsWith("customfield_")) {
            CustomField customField;
            Long id = this.getId(elementName);
            CustomField customField2 = customField = id != null ? this.customFieldManager.getCustomFieldObject(id) : null;
            if (customField == null) {
                log.warn((Object)("Unable to find custom field in system with id '" + id + "', converting anyway."));
            }
            String customFieldKey = customField != null ? customField.getCustomFieldType().getKey() : null;
            ClauseXmlHandler clauseXmlHandler = null;
            if (customFieldKey != null) {
                clauseXmlHandler = this.handlers.get(searchParameterClassName + ":" + customFieldKey);
            }
            if (clauseXmlHandler == null) {
                clauseXmlHandler = this.handlers.get(searchParameterClassName);
            }
            return clauseXmlHandler;
        }
        ClauseXmlHandler handler = this.handlers.get(searchParameterClassName + ":" + elementName);
        if (handler == null) {
            handler = this.handlers.get(searchParameterClassName);
        }
        return handler;
    }

    private Long getId(String elementName) {
        try {
            if (elementName.endsWith("_group")) {
                elementName = elementName.substring(0, elementName.indexOf("_group"));
            }
            return Long.parseLong(elementName.substring("customfield_".length()));
        }
        catch (Exception e) {
            return null;
        }
    }
}

