/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.GlobalPermissionsCache;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.security.JiraPermissionImpl;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultGlobalPermissionManager
implements GlobalPermissionManager {
    private final GlobalPermissionsCache cache;
    private final CrowdService crowdService;

    public DefaultGlobalPermissionManager(CrowdService crowdService) {
        this.crowdService = crowdService;
        this.cache = new GlobalPermissionsCache();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.refresh();
    }

    public boolean addPermission(int permissionId, String group) throws CreateException {
        if (!Permissions.isGlobalPermission((int)permissionId)) {
            throw new IllegalArgumentException("PermissionType passed must be a global permissions " + permissionId + " is not");
        }
        if (permissionId == 1 && group == null) {
            throw new IllegalArgumentException("The group Anyone cannot be added to the global permission JIRA Users");
        }
        try {
            EntityUtils.createValue("SchemePermissions", (Map<String, Object>)FieldMap.build((String)"permission", (Object)new Long(permissionId)).add("type", (Object)"group").add("parameter", (Object)group));
            this.cache.refresh();
            this.clearActiveUserCountIfNecessary(permissionId);
            return true;
        }
        catch (DataAccessException e) {
            throw new CreateException((Exception)((Object)e));
        }
    }

    public Collection<JiraPermission> getPermissions(int permissionType) {
        return this.cache.getPermissions(permissionType);
    }

    public boolean removePermission(int permissionId, String group) throws RemoveException {
        if (!Permissions.isGlobalPermission((int)permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must be a global permission, " + permissionId + " is not");
        }
        JiraPermissionImpl jiraPermission = new JiraPermissionImpl(permissionId, group, "group");
        if (this.hasPermission(jiraPermission)) {
            GenericValue permGV = this.cache.getPermission(jiraPermission);
            try {
                ComponentAccessor.getOfBizDelegator().removeAll((List)Lists.newArrayList((Object[])new GenericValue[]{permGV}));
                this.cache.refresh();
                this.clearActiveUserCountIfNecessary(permissionId);
                return true;
            }
            catch (DataAccessException e) {
                throw new RemoveException((Exception)((Object)e));
            }
        }
        return false;
    }

    public boolean removePermissions(String group) throws RemoveException {
        if (group == null) {
            throw new IllegalArgumentException("Group passed must NOT be null");
        }
        if (this.crowdService.getGroup(group) == null) {
            throw new IllegalArgumentException("Group passed must exist");
        }
        Set<JiraPermission> permissions = this.cache.getPermissions();
        for (JiraPermission permission : permissions) {
            if (!group.equals(permission.getGroup())) continue;
            try {
                this.cache.getPermission(permission).remove();
                this.clearActiveUserCountIfNecessary(permission.getType());
            }
            catch (GenericEntityException e) {
                throw new RemoveException((Exception)((Object)e));
            }
        }
        this.cache.refresh();
        return true;
    }

    public boolean hasPermission(int permissionId) {
        if (!Permissions.isGlobalPermission((int)permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must a global permission, " + permissionId + " is not");
        }
        return this.hasPermission(new JiraPermissionImpl(permissionId));
    }

    public boolean hasPermission(int permissionId, User u) {
        if (!Permissions.isGlobalPermission((int)permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must a global permission, " + permissionId + " is not");
        }
        if (u == null) {
            throw new IllegalArgumentException("User passed to this function cannot be null");
        }
        if (this.hasPermission(permissionId)) {
            return true;
        }
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(u.getName()).returningAtMost(-1);
        Iterable groups = this.crowdService.search((Query)membershipQuery);
        for (String groupName : groups) {
            if (!this.hasPermission(new JiraPermissionImpl(permissionId, groupName, "group"))) continue;
            return true;
        }
        return false;
    }

    public Collection<Group> getGroupsWithPermission(int permissionId) {
        ArrayList<Group> groups = new ArrayList<Group>();
        Collection<String> groupNames = this.getGroupNames(permissionId);
        for (String groupName : groupNames) {
            Group group = this.crowdService.getGroup(groupName);
            if (group == null) continue;
            groups.add(group);
        }
        return Collections.unmodifiableCollection(groups);
    }

    public Collection<String> getGroupNames(int permissionId) {
        if (!Permissions.isGlobalPermission((int)permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must a global permission, " + permissionId + " is not");
        }
        HashSet<String> groupNames = new HashSet<String>();
        Collection<JiraPermission> permissions = this.cache.getPermissions(permissionId);
        for (JiraPermission jiraPermission : permissions) {
            String group = jiraPermission.getGroup();
            if (group == null) continue;
            groupNames.add(group);
        }
        return Collections.unmodifiableCollection(groupNames);
    }

    protected boolean hasPermission(JiraPermission jiraPermission) {
        if (0 == jiraPermission.getType()) {
            return this.cache.hasPermission(jiraPermission) || this.cache.hasPermission(new JiraPermissionImpl(44, jiraPermission.getGroup(), jiraPermission.getPermType()));
        }
        return this.cache.hasPermission(jiraPermission);
    }

    private void clearActiveUserCountIfNecessary(int permissionId) {
        Set usePermissions = Permissions.getUsePermissions();
        if (usePermissions.contains(permissionId)) {
            this.getUserUtil().clearActiveUserCount();
        }
    }

    UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

