/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionStore;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class OfBizVersionStore
implements VersionStore {
    private final OfBizDelegator delegator;

    public OfBizVersionStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public List<GenericValue> getAllVersions() {
        return new ArrayList<GenericValue>(this.delegator.findAll("Version", (List)ImmutableList.of((Object)"sequence")));
    }

    @Override
    public List<GenericValue> getVersionsByName(String name) {
        List<GenericValue> versionGvs = this.getAllVersions();
        ArrayList<GenericValue> filteredVersions = new ArrayList<GenericValue>();
        for (GenericValue versionGv : versionGvs) {
            if (!name.equalsIgnoreCase(versionGv.getString("name"))) continue;
            filteredVersions.add(versionGv);
        }
        return filteredVersions;
    }

    @Override
    public List<GenericValue> getVersionsByProject(Long projectId) {
        return new ArrayList<GenericValue>(this.delegator.findByAnd("Version", EasyMap.build((Object)"project", (Object)projectId), (List)ImmutableList.of((Object)"sequence")));
    }

    @Override
    public GenericValue createVersion(Map<String, Object> versionParams) {
        return this.delegator.createValue("Version", versionParams);
    }

    @Override
    public void storeVersion(Version version) {
        this.delegator.store(version.getGenericValue());
    }

    @Override
    public void storeVersions(Collection<Version> versions) {
        for (Version version : versions) {
            if (version == null) continue;
            this.storeVersion(version);
        }
    }

    @Override
    public GenericValue getVersion(Long id) {
        return this.delegator.findById("Version", id);
    }

    @Override
    public void deleteVersion(GenericValue versionGV) {
        this.delegator.removeValue(versionGV);
    }
}

