/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.customfield;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldDefaultVelocityParams;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import webwork.action.Action;

public class CustomFieldTypeModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<CustomFieldType>
implements CustomFieldTypeModuleDescriptor {
    private RendererManager rendererManager;
    private final CustomFieldDefaultVelocityParams customFieldDefaultVelocityParams;
    private Set<String> validSearcherKeys;

    public CustomFieldTypeModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, RendererManager rendererManager, ModuleFactory moduleFactory, CustomFieldDefaultVelocityParams customFieldDefaultVelocityParams) {
        super(authenticationContext, moduleFactory);
        this.rendererManager = rendererManager;
        this.customFieldDefaultVelocityParams = customFieldDefaultVelocityParams;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.validSearcherKeys = new HashSet<String>();
        List searcherElements = element.elements("valid-searcher");
        for (Element searcherElement : searcherElements) {
            String packageName = searcherElement.attributeValue("package");
            String key = searcherElement.attributeValue("key");
            this.validSearcherKeys.add(packageName + ":" + key);
        }
    }

    public Set<String> getValidSearcherKeys() {
        return this.validSearcherKeys;
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(CustomFieldType.class);
    }

    public boolean isViewTemplateExists() {
        return this.isResourceExist("view");
    }

    public boolean isColumnViewTemplateExists() {
        return this.isResourceExist("column-view");
    }

    public boolean isEditTemplateExists() {
        return this.isResourceExist("edit");
    }

    public boolean isXMLTemplateExists() {
        return this.isResourceExist("xml");
    }

    public String getEditHtml(FieldConfig config, Map customFieldValuesHolder, Issue issue, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem) {
        Assertions.notNull((String)"config", (Object)config);
        Map params = CustomFieldUtils.buildParams((CustomField)config.getCustomField(), (FieldConfig)config, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, null, (Map)customFieldValuesHolder, (Action)action, (Map)displayParameters);
        return this.getHtml("edit", params);
    }

    public String getBulkMoveHtml(FieldConfig config, Map customFieldValuesHolder, Issue issue, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem, Map<Long, BulkMoveHelper.DistinctValueResult> distinctValues, BulkMoveHelper bulkMoveHelper) {
        Assertions.notNull((String)"config", (Object)config);
        Map params = CustomFieldUtils.buildParams((CustomField)config.getCustomField(), (FieldConfig)config, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, null, (Map)customFieldValuesHolder, (Action)action, (Map)displayParameters);
        params.put("valuesToMap", distinctValues);
        params.put("bulkMoveHelper", bulkMoveHelper);
        String html = this.getResourceDescriptor("velocity", "bulk-move") != null ? this.getHtml("bulk-move", params) : this.getHtml("edit", params);
        return html;
    }

    public String getEditDefaultHtml(FieldConfig config, Map customFieldValuesHolder, Issue issue, Action action, Map displayParameters, FieldLayoutItem fieldLayoutItem) {
        Assertions.notNull((String)"config", (Object)config);
        Map params = CustomFieldUtils.buildParams((CustomField)config.getCustomField(), (FieldConfig)config, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, null, (Map)customFieldValuesHolder, (Action)action, (Map)displayParameters);
        String html = this.getResourceDescriptor("velocity", "edit-default") != null ? this.getHtml("edit-default", params) : this.getHtml("edit", params);
        return html;
    }

    public String getColumnViewHtml(CustomField field, Object value, Issue issue, Map displayParams, FieldLayoutItem fieldLayoutItem) {
        if (this.isResourceExist("column-view")) {
            return this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "column-view", displayParams);
        }
        return this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "view", displayParams);
    }

    public String getViewHtml(CustomField field, Object value, Issue issue, FieldLayoutItem fieldLayoutItem) {
        return this.getViewHtml(field, value, issue, fieldLayoutItem, null);
    }

    public String getViewHtml(CustomField field, Object value, Issue issue, FieldLayoutItem fieldLayoutItem, Map displayParameters) {
        return this.getViewHtmlByValue(fieldLayoutItem, value, field, issue, "view", displayParameters);
    }

    public String getViewXML(CustomField field, Issue issue, FieldLayoutItem fieldLayoutItem, boolean raw) {
        Map<String, Object> combinedMap = this.getCombinedMap(field.getCustomFieldType().getVelocityParameters(issue, field, fieldLayoutItem), MapBuilder.build((Object)"value", (Object)field.getValue(issue)));
        if (field.isRenderable() && !raw) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            combinedMap.put("renderedValue", this.rendererManager.getRenderedContent(rendererType, (String)field.getValue(issue), issue.getIssueRenderContext()));
        }
        return this.getHtml("xml", combinedMap);
    }

    public String getDefaultViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        CustomField customField = fieldConfig.getCustomField();
        Object value = customField.getCustomFieldType().getDefaultValue(fieldConfig);
        if (customField.isRenderable()) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            return this.rendererManager.getRenderedContent(rendererType, (String)value, null);
        }
        return this.getViewHtmlByValue(fieldLayoutItem, value, customField, null, "view", null);
    }

    private String getViewHtmlByValue(FieldLayoutItem fieldLayoutItem, Object value, CustomField field, Issue issue, String templateNameView, Map displayParams) {
        Map params = CustomFieldUtils.buildParams((CustomField)field, null, (Issue)issue, (FieldLayoutItem)fieldLayoutItem, (Object)value, null, null, (Map)displayParams);
        return this.getHtml(templateNameView, params);
    }

    @Override
    public String getHtml(String resourceName, Map<String, ?> startingParams) {
        return super.getHtml(resourceName, this.customFieldDefaultVelocityParams.combine(startingParams));
    }

    private Map<String, Object> getCombinedMap(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (map1 != null) {
            allParams.putAll(map1);
        }
        if (map2 != null) {
            allParams.putAll(map2);
        }
        return allParams;
    }
}

