/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.watchers;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.issue.watchers.WatchedIssuesAccessor;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;

public class DefaultWatchedIssuesAccessor
implements WatchedIssuesAccessor {
    private final WatcherManager watcherManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory factory;

    public DefaultWatchedIssuesAccessor(@NotNull WatcherManager watcherManager, @NotNull SearchProvider searchProvider, @NotNull SearchProviderFactory factory) {
        this.watcherManager = (WatcherManager)Assertions.notNull((String)"watcherManager", (Object)watcherManager);
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.factory = (SearchProviderFactory)Assertions.notNull((String)"factory", (Object)factory);
    }

    public Iterable<Long> getWatchedIssueIds(User watcher, User searcher, WatchedIssuesAccessor.Security security) {
        IssueIdCollector collector = new IssueIdCollector();
        Query query = DefaultWatchedIssuesAccessor.getQuery(watcher);
        try {
            switch (security) {
                case OVERRIDE: {
                    this.searchProvider.searchOverrideSecurity(query, searcher, (Collector)collector);
                    break;
                }
                case RESPECT: {
                    this.searchProvider.search(query, searcher, (Collector)collector);
                }
            }
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return collector.getIds();
    }

    public boolean isWatchingEnabled() {
        return this.watcherManager.isWatchingEnabled();
    }

    static Query getQuery(User user) {
        return JqlQueryBuilder.newBuilder().where().watcherUser(user.getName()).endWhere().buildQuery();
    }

    private class IssueIdCollector
    extends DocumentHitCollector {
        private final CollectionBuilder<String> issueIds;

        public IssueIdCollector() {
            super(DefaultWatchedIssuesAccessor.this.factory.getSearcher("issues"));
            this.issueIds = CollectionBuilder.newBuilder();
        }

        public void collect(Document d) {
            this.issueIds.add((Object)d.get("issue_id"));
        }

        Iterable<Long> getIds() {
            return Transformed.list((List)this.issueIds.asList(), (Function)new Function<String, Long>(){

                public Long get(String input) {
                    return Long.valueOf(input);
                }
            });
        }
    }
}

