/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.comparator.NullComparator;

public class KickassUserSearchInput
implements Comparable<KickassUserSearchInput> {
    private Object object;
    private final InputType type;
    private final String value;

    private KickassUserSearchInput(InputType type, String value) {
        this.type = type;
        this.value = value;
    }

    public static KickassUserSearchInput currentUser() {
        return new KickassUserSearchInput(InputType.CURRENT_USER, null);
    }

    public static KickassUserSearchInput empty() {
        return new KickassUserSearchInput(InputType.EMPTY, null);
    }

    public static KickassUserSearchInput group(String name) {
        return new KickassUserSearchInput(InputType.GROUP, name);
    }

    public static KickassUserSearchInput user(String name) {
        return new KickassUserSearchInput(InputType.USER, name);
    }

    @Override
    public int compareTo(KickassUserSearchInput other) {
        boolean bothGroupsOrUsers;
        boolean bl = bothGroupsOrUsers = !(this.type != InputType.GROUP && this.type != InputType.USER || other.type != InputType.GROUP && other.type != InputType.USER);
        if (!bothGroupsOrUsers) {
            return this.type.compareTo(other.type);
        }
        return new NullComparator().compare(this.getCompareValue(), other.getCompareValue());
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        KickassUserSearchInput input = (KickassUserSearchInput)that;
        if (this.type != input.getType()) {
            return false;
        }
        String inputValue = input.getValue();
        return !(this.value != null ? !this.value.equals(inputValue) : inputValue != null);
    }

    private String getCompareValue() {
        if (this.object != null) {
            if (this.isGroup()) {
                return ((Group)this.object).getName().toLowerCase();
            }
            if (this.isUser()) {
                return ((User)this.object).getDisplayName().toLowerCase();
            }
        }
        return null;
    }

    public Object getObject() {
        return this.object;
    }

    public InputType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean isCurrentUser() {
        return this.type == InputType.CURRENT_USER;
    }

    public boolean isEmpty() {
        return this.type == InputType.EMPTY;
    }

    public boolean isGroup() {
        return this.type == InputType.GROUP;
    }

    public boolean isUser() {
        return this.type == InputType.USER;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public static enum InputType {
        CURRENT_USER,
        EMPTY,
        GROUP,
        USER;

    }
}

