/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.customfields.converters.DateConverter;
import com.atlassian.jira.issue.customfields.converters.DateTimeConverter;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherInputHelper;
import com.atlassian.jira.issue.search.searchers.util.DefaultDateSearcherInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateSearchInputTransformer
implements SearchInputTransformer {
    private static final Logger log = Logger.getLogger(DateSearchInputTransformer.class);
    private final DateSearcherConfig dateSearcherConfig;
    private final DateConverter dateConverter;
    private final JqlOperandResolver operandResolver;
    private final JqlDateSupport jqlDateSupport;
    private final DateTimeConverter dateTimeConverter;
    private boolean allowTimeComponent;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final TimeZoneManager timeZoneManager;
    private final CustomFieldInputHelper customFieldInputHelper;

    public DateSearchInputTransformer(boolean allowTimeComponent, DateSearcherConfig config, DateConverter dateConverter, DateTimeConverter dateTimeConverter, JqlOperandResolver operandResolver, JqlDateSupport jqlDateSupport, CustomFieldInputHelper customFieldInputHelper, TimeZoneManager timeZoneManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.allowTimeComponent = allowTimeComponent;
        this.dateSearcherConfig = (DateSearcherConfig)Assertions.notNull((String)"config", (Object)config);
        this.dateConverter = (DateConverter)Assertions.notNull((String)"dateConverter", (Object)dateConverter);
        this.dateTimeConverter = (DateTimeConverter)Assertions.notNull((String)"dateTimeConverter", (Object)dateTimeConverter);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.jqlDateSupport = (JqlDateSupport)Assertions.notNull((String)"jqlDateSupport", (Object)jqlDateSupport);
        this.customFieldInputHelper = (CustomFieldInputHelper)Assertions.notNull((String)"customFieldInputHelper", (Object)customFieldInputHelper);
        this.timeZoneManager = (TimeZoneManager)Assertions.notNull((String)"timeZoneManager", (Object)timeZoneManager);
        this.dateTimeFormatterFactory = (DateTimeFormatterFactory)Assertions.notNull((String)"dateTimeFormatterFactory", (Object)dateTimeFormatterFactory);
    }

    public void populateFromParams(User user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        Assertions.notNull((String)"actionParams", (Object)actionParams);
        fieldValuesHolder.put((Object)this.dateSearcherConfig.getBeforeField(), (Object)actionParams.getFirstValueForKey(this.dateSearcherConfig.getBeforeField()));
        fieldValuesHolder.put((Object)this.dateSearcherConfig.getAfterField(), (Object)actionParams.getFirstValueForKey(this.dateSearcherConfig.getAfterField()));
        fieldValuesHolder.put((Object)this.dateSearcherConfig.getPreviousField(), (Object)actionParams.getFirstValueForKey(this.dateSearcherConfig.getPreviousField()));
        fieldValuesHolder.put((Object)this.dateSearcherConfig.getNextField(), (Object)actionParams.getFirstValueForKey(this.dateSearcherConfig.getNextField()));
    }

    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        Assertions.notNull((String)"i18nHelper", (Object)i18nHelper);
        Assertions.notNull((String)"errors", (Object)errors);
        this.validateAbsoluteDates(fieldValuesHolder, errors, i18nHelper);
        this.validateRelativeDates(fieldValuesHolder, errors, i18nHelper);
    }

    private void validateAbsoluteDates(FieldValuesHolder fieldValuesHolder, ErrorCollection errors, I18nHelper i18nHelper) {
        String[] dateParamNames = this.dateSearcherConfig.getAbsoluteFields();
        Date[] dateParamValues = new Date[2];
        int i = 0;
        for (String dateParamName : dateParamNames) {
            String dateString = (String)fieldValuesHolder.get((Object)dateParamName);
            if (StringUtils.isNotEmpty((String)dateString)) {
                DateTimeFormatter formatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_PICKER);
                try {
                    dateParamValues[i] = formatter.parse(dateString);
                }
                catch (IllegalArgumentException e) {
                    errors.addError(dateParamName, i18nHelper.getText("fields.validation.data.format", formatter.getFormatHint()));
                }
            }
            ++i;
        }
        Date afterDate = dateParamValues[0];
        Date beforeDate = dateParamValues[1];
        if (afterDate != null && beforeDate != null && beforeDate.compareTo(afterDate) < 0) {
            errors.addError(this.dateSearcherConfig.getAfterField(), i18nHelper.getText("fields.validation.date.absolute.before.after"));
        }
    }

    private void validateRelativeDates(FieldValuesHolder fieldValuesHolder, ErrorCollection errors, I18nHelper i18nHelper) {
        String[] periodParamNames = this.dateSearcherConfig.getRelativeFields();
        String[] periodParamLabels = new String[]{i18nHelper.getText("navigator.filter.constants.duedate.from"), i18nHelper.getText("navigator.filter.constants.duedate.to")};
        for (int i = 0; i < periodParamNames.length; ++i) {
            String periodParam = (String)fieldValuesHolder.get((Object)periodParamNames[i]);
            if (!StringUtils.isNotEmpty((String)periodParam)) continue;
            try {
                DateUtils.getDurationWithNegative((String)periodParam);
                continue;
            }
            catch (InvalidDurationException e) {
                errors.addError(periodParamNames[i], i18nHelper.getText("fields.validation.date.period.format", periodParamLabels[i]));
                continue;
            }
            catch (NumberFormatException e) {
                errors.addError(periodParamNames[i], i18nHelper.getText("fields.validation.date.period.format", periodParamLabels[i]));
            }
        }
        String previousDateString = (String)fieldValuesHolder.get((Object)this.dateSearcherConfig.getPreviousField());
        String nextDateString = (String)fieldValuesHolder.get((Object)this.dateSearcherConfig.getNextField());
        if (StringUtils.isNotEmpty((String)previousDateString) && StringUtils.isNotEmpty((String)nextDateString)) {
            try {
                long prevDateLong = DateUtils.getDurationWithNegative((String)previousDateString);
                long nextDateLong = DateUtils.getDurationWithNegative((String)nextDateString);
                if (prevDateLong > nextDateLong) {
                    errors.addError(this.dateSearcherConfig.getPreviousField(), i18nHelper.getText("fields.validation.date.period.from.to"));
                }
            }
            catch (InvalidDurationException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void populateFromQuery(User user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        DateSearcherInputHelper helper;
        DateSearcherInputHelper.ConvertClauseResult clauseResult;
        Map result;
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        Assertions.notNull((String)"query", (Object)query);
        if (query.getWhereClause() != null && (result = (clauseResult = (helper = this.createDateSearcherInputHelper()).convertClause(query.getWhereClause(), user, this.allowTimeComponent)).getFields()) != null) {
            fieldValuesHolder.putAll(result);
        }
    }

    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            Clause whereClause = query.getWhereClause();
            DateSearcherInputHelper inputHelper = this.createDateSearcherInputHelper();
            return inputHelper.convertClause(whereClause, user, this.allowTimeComponent).fitsFilterForm();
        }
        return true;
    }

    DateSearcherInputHelper createDateSearcherInputHelper() {
        return new DefaultDateSearcherInputHelper(this.dateSearcherConfig, this.operandResolver, this.jqlDateSupport, this.dateConverter, this.dateTimeConverter, this.timeZoneManager);
    }

    public Clause getSearchClause(User user, FieldValuesHolder fieldValuesHolder) {
        Assertions.notNull((String)"fieldValuesHolder", (Object)fieldValuesHolder);
        String clauseName = this.getClauseName(user);
        Clause relativeClause = this.createPeriodClause((String)fieldValuesHolder.get((Object)this.dateSearcherConfig.getPreviousField()), (String)fieldValuesHolder.get((Object)this.dateSearcherConfig.getNextField()), clauseName);
        Clause absoluteClause = this.createDateClause((String)fieldValuesHolder.get((Object)this.dateSearcherConfig.getAfterField()), (String)fieldValuesHolder.get((Object)this.dateSearcherConfig.getBeforeField()), clauseName);
        return DateSearchInputTransformer.createCompoundClause(relativeClause, absoluteClause);
    }

    private Clause createPeriodClause(String lower, String upper, String clauseName) {
        return DateSearchInputTransformer.createCompoundClause(this.parsePeriodClause(lower, Operator.GREATER_THAN_EQUALS, clauseName), this.parsePeriodClause(upper, Operator.LESS_THAN_EQUALS, clauseName));
    }

    private Clause parsePeriodClause(String period, Operator operator, String clauseName) {
        if (StringUtils.isBlank((String)period)) {
            return null;
        }
        return new TerminalClauseImpl(clauseName, operator, period);
    }

    private Clause createDateClause(String lower, String upper, String clauseName) {
        Clause fromClause = this.createDateClause(lower, Operator.GREATER_THAN_EQUALS, clauseName);
        Clause toClause = this.createDateClause(upper, Operator.LESS_THAN_EQUALS, clauseName);
        return DateSearchInputTransformer.createCompoundClause(fromClause, toClause);
    }

    private Clause createDateClause(String date, Operator operator, String clauseName) {
        if (StringUtils.isNotBlank((String)date)) {
            try {
                String jqlDate;
                Date parsedDate = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_PICKER).forLoggedInUser().parse(date);
                if (parsedDate != null && (jqlDate = this.jqlDateSupport.getDateString(parsedDate)) != null) {
                    return new TerminalClauseImpl(clauseName, operator, jqlDate);
                }
            }
            catch (IllegalArgumentException e) {
                log.info((Object)String.format("Unable to parse date '%s'.", date));
            }
            return new TerminalClauseImpl(clauseName, operator, date);
        }
        return null;
    }

    private static Clause createCompoundClause(Clause left, Clause right) {
        if (left == null) {
            return right;
        }
        if (right != null) {
            return new AndClause(new Clause[]{left, right});
        }
        return left;
    }

    private String getClauseName(User searcher) {
        String fieldName;
        String primaryName = this.dateSearcherConfig.getClauseNames().getPrimaryName();
        if (primaryName.equalsIgnoreCase(fieldName = this.dateSearcherConfig.getFieldName())) {
            return fieldName;
        }
        return this.customFieldInputHelper.getUniqueClauseName(searcher, primaryName, fieldName);
    }
}

