/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.ComponentsIndexer;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.ComponentSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.KickassComponentSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.ComponentSearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.ComponentSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.ComponentIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;

public class ComponentsSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final KickassSearchContext kickassSearchContext;
    private final KickassComponentSearchRenderer kickassSearchRenderer;
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public ComponentsSearcher(VelocityTemplatingEngine templatingEngine, VelocityRequestContextFactory contextFactory, FieldVisibilityManager fieldVisibilityManager, ComponentResolver componentResolver, ApplicationProperties applicationProperties, ProjectComponentManager componentManager, ProjectManager projectManager, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, KickassSearchContext kickassSearchContext) {
        SimpleFieldSearchConstantsWithEmpty searchConstants = SystemSearchConstants.forComponent();
        ComponentSearchContextVisibilityChecker searchContextVisibilityChecker = new ComponentSearchContextVisibilityChecker(componentManager);
        ComponentIndexInfoResolver indexInfoResolver = new ComponentIndexInfoResolver(componentResolver);
        this.kickassSearchContext = kickassSearchContext;
        this.searcherInformation = new GenericSearcherInformation(searchConstants.getSearcherId(), "common.filters.incomponents", Collections.singletonList(ComponentsIndexer.class), this.fieldReference, SearcherGroupType.PROJECT);
        this.kickassSearchRenderer = new KickassComponentSearchRenderer(applicationProperties, fieldVisibilityManager, componentManager, projectManager, searchConstants, this.searcherInformation.getNameKey(), templatingEngine, contextFactory);
        this.searchRenderer = new ComponentSearchRenderer(searchConstants, contextFactory, fieldVisibilityManager, applicationProperties, templatingEngine, this.searcherInformation.getNameKey(), componentManager, projectManager, componentResolver);
        this.searchInputTransformer = new ComponentSearchInputTransformer(searchConstants.getJqlClauseNames(), searchConstants.getUrlParameter(), indexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker, componentResolver);
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.kickassSearchContext.isEnabled()) {
            return this.kickassSearchRenderer;
        }
        return this.searchRenderer;
    }
}

