/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class ResolutionQuickSearchHandler
extends SingleWordQuickSearchHandler {
    private static final String UNRESOLVED = "unresolved";
    private static final Map<String, String> UNRESOLVED_RESULT = ImmutableMap.of((Object)"resolution", (Object)"-1");
    public final ConstantsManager constantsManager;

    public ResolutionQuickSearchHandler(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public GenericValue getResolutionsByName(String name) {
        return ResolutionQuickSearchHandler.getByName(this.constantsManager.getResolutions(), name);
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        if (UNRESOLVED.equalsIgnoreCase(word)) {
            return UNRESOLVED_RESULT;
        }
        GenericValue resolutionByName = this.getResolutionsByName(word);
        return resolutionByName != null ? EasyMap.build((Object)"resolution", (Object)resolutionByName.getString("id")) : null;
    }
}

