/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractFieldScreenRenderer
implements FieldScreenRenderer {
    AbstractFieldScreenRenderer() {
    }

    public Collection<FieldScreenRenderLayoutItem> getRequiredFieldScreenRenderItems() {
        LinkedList<FieldScreenRenderLayoutItem> items = new LinkedList<FieldScreenRenderLayoutItem>();
        List tabList = this.getFieldScreenRenderTabs();
        if (tabList != null) {
            for (FieldScreenRenderTab fieldScreenRenderTab : tabList) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    if (!fieldScreenRenderLayoutItem.isRequired()) continue;
                    items.add(fieldScreenRenderLayoutItem);
                }
            }
        }
        return items;
    }

    public FieldScreenRenderTab getFieldScreenRenderTabPosition(String fieldId) {
        List tabList = this.getFieldScreenRenderTabs();
        if (tabList != null) {
            for (FieldScreenRenderTab fieldScreenRenderTab : tabList) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    if (!fieldScreenRenderLayoutItem.getOrderableField().getId().equals(fieldId)) continue;
                    return fieldScreenRenderTab;
                }
            }
        }
        return null;
    }

    public FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem(OrderableField orderableField) {
        List tabList = this.getFieldScreenRenderTabs();
        if (tabList != null) {
            for (FieldScreenRenderTab fieldScreenRenderTab : tabList) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    if (!fieldScreenRenderLayoutItem.getOrderableField().getId().equals(orderableField.getId())) continue;
                    return fieldScreenRenderLayoutItem;
                }
            }
        }
        return new FieldScreenRenderLayoutItemImpl(null, this.getFieldLayout().getFieldLayoutItem(orderableField));
    }

    public List<FieldScreenRenderLayoutItem> getAllScreenRenderItems() {
        ArrayList<FieldScreenRenderLayoutItem> returnList = new ArrayList<FieldScreenRenderLayoutItem>();
        List tabList = this.getFieldScreenRenderTabs();
        if (tabList != null) {
            for (FieldScreenRenderTab fieldScreenRenderTab : tabList) {
                returnList.addAll(fieldScreenRenderTab.getFieldScreenRenderLayoutItems());
            }
        }
        return returnList;
    }
}

