/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.fields.renderer.wiki.WikiRendererFactory;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.V2RendererFacade;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.DisposableBean;

public class AtlassianWikiRenderer
implements JiraRendererPlugin,
DisposableBean {
    public static final String ISSUE_CONTEXT_KEY = "jira.issue";
    public static final String RENDERER_TYPE = "atlassian-wiki-renderer";
    public static final String RENDER_CUSTOM_FIELD_NAME = "atlassian-wiki-renderer-custom-field-name";
    private volatile JiraRendererModuleDescriptor jiraRendererModuleDescriptor;
    private final WikiRendererFactory wikiFactory = new WikiRendererFactory();
    private final EventPublisher eventPublisher;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public AtlassianWikiRenderer(EventPublisher eventPublisher, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.eventPublisher = eventPublisher;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.eventPublisher.register((Object)this.wikiFactory);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this.wikiFactory);
    }

    public String render(String value, IssueRenderContext context) {
        return this.getRendererFacade().convertWikiToXHtml(this.getRenderContext(context), value);
    }

    public String renderAsText(String value, IssueRenderContext context) {
        return this.getRendererFacade().convertWikiToText(this.getRenderContext(context), value);
    }

    public String getRendererType() {
        return RENDERER_TYPE;
    }

    public Object transformForEdit(Object rawValue) {
        return rawValue;
    }

    public Object transformFromEdit(Object editValue) {
        return editValue;
    }

    public void init(JiraRendererModuleDescriptor jiraRendererModuleDescriptor) {
        this.jiraRendererModuleDescriptor = jiraRendererModuleDescriptor;
    }

    public JiraRendererModuleDescriptor getDescriptor() {
        return this.jiraRendererModuleDescriptor;
    }

    private V2RendererFacade getRendererFacade() {
        return this.getWikiRendererFactory().getWikiRenderer();
    }

    RenderContext getRenderContext(IssueRenderContext context) {
        RenderContext renderContext = new RenderContext();
        if (context != null) {
            renderContext.getParams().putAll(context.getParams());
            if (context.getIssue() != null) {
                renderContext.addParam((Object)ISSUE_CONTEXT_KEY, (Object)context.getIssue());
            }
        }
        renderContext.setBaseUrl(this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponentOfType(ApplicationProperties.class);
        String mimeSniffingPolicy = applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround");
        RenderMode renderMode = null;
        renderMode = mimeSniffingPolicy.equalsIgnoreCase("insecure") ? RenderMode.suppress((long)16384L) : (mimeSniffingPolicy.equalsIgnoreCase("secure") ? RenderMode.suppress((long)49184L) : (mimeSniffingPolicy.equalsIgnoreCase("workaround") ? RenderMode.suppress((long)49152L) : RenderMode.ALL));
        if (context != null && BooleanUtils.isTrue((Boolean)(context.getParam((Object)RENDER_CUSTOM_FIELD_NAME) != null ? 1 : 0))) {
            renderMode = renderMode.and(RenderMode.suppress((long)1L));
        }
        renderContext.pushRenderMode(renderMode);
        return renderContext;
    }

    private WikiRendererFactory getWikiRendererFactory() {
        return this.wikiFactory;
    }
}

