/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.AbstractTextSystemField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.EnvironmentRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.EnvironmentSearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparator;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public class EnvironmentSystemField
extends AbstractTextSystemField
implements HideableField,
RequirableField,
RestFieldOperations {
    private static final String ENVIRONMENT_NAME_KEY = "issue.field.environment";
    private final RendererManager rendererManager;
    private static final LuceneFieldSorter SORTER = new TextFieldSorter("environment");
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;

    public EnvironmentSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, EnvironmentSearchHandlerFactory searchHandlerFactory, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        super("environment", ENVIRONMENT_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, rendererManager, permissionManager, searchHandlerFactory);
        this.rendererManager = rendererManager;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String environment = (String)fieldValuesHolder.get(this.getId());
        if (fieldScreenRenderLayoutItem.isRequired() && (!TextUtils.stringSet((String)environment) || environment.trim().length() <= 0)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        }
        if (this.textFieldCharacterLengthValidator.isTextTooLong(environment)) {
            long maximumNumberOfCharacters = this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters();
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("field.error.text.toolong", (Object)maximumNumberOfCharacters));
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    @Override
    public String getValueFromIssue(Issue issue) {
        return issue.getEnvironment();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String env = (String)this.rendererManager.getRendererForType(rendererType).transformFromEdit(this.getValueFromParams(fieldValueHolder));
            if (TextUtils.stringSet((String)env)) {
                issue.setEnvironment(env);
            } else {
                issue.setEnvironment(null);
            }
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setEnvironment(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.environment";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return SORTER;
    }

    @Override
    public List<SortField> getSortFields(boolean sortOrder) {
        return Collections.singletonList(new SortField("sort_environment", (FieldComparatorSource)new StringSortComparator(), sortOrder));
    }

    @Override
    protected String getEditTemplateName() {
        return "environment-edit.vm";
    }

    @Override
    protected String getColumnViewTemplateName() {
        return "environment-columnview.vm";
    }

    @Override
    protected boolean isInvertCollapsedState() {
        return true;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        String rendererType = null;
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (fieldLayout.isFieldHidden(this.getId())) {
                return "bulk.edit.unavailable.hidden";
            }
            if (rendererType == null) {
                rendererType = fieldLayout.getRendererTypeForField("environment");
                continue;
            }
            if (rendererType.equals(fieldLayout.getRendererTypeForField("environment"))) continue;
            return "bulk.edit.unavailable.different.renderers";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new EnvironmentRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }
}

