/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.CustomFieldOptionJsonBean;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CascadingSelectCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Map<String, Option>> {
    private final OptionsManager optionsManager;

    public CascadingSelectCustomFieldOperationsHandler(OptionsManager optionsManager, CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
        this.optionsManager = optionsManager;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName());
    }

    protected Map<String, Option> handleSetOperation(IssueContext issueCtx, Issue issue, Map<String, Option> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operationValue.isNull()) {
            return null;
        }
        Option parent = null;
        Option child = null;
        CustomFieldOptionJsonBean bean = (CustomFieldOptionJsonBean)operationValue.convertValue(this.field.getId(), CustomFieldOptionJsonBean.class, errors);
        if (bean == null) {
            return null;
        }
        FieldConfig config = this.field.getRelevantConfig(issueCtx);
        Options allowedOptions = this.optionsManager.getOptions(config);
        if (bean.getId() != null) {
            parent = this.findOptionById(bean.getId(), this.field, errors);
            if (parent == null || !allowedOptions.contains(parent)) {
                errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.id.invalid", bean.getId()), ErrorCollection.Reason.VALIDATION_FAILED);
                parent = null;
            }
        } else {
            String value = bean.getValue();
            if (value != null) {
                for (Option option : allowedOptions) {
                    if (!option.getValue().equals(value)) continue;
                    parent = option;
                    break;
                }
                if (parent == null) {
                    errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.value.invalid", value), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else {
                errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.parent.no.name.or.id"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (parent != null) {
            List children = parent.getChildOptions();
            CustomFieldOptionJsonBean beanChild = bean.getChild();
            if (beanChild != null) {
                if (beanChild.getId() != null) {
                    child = this.findOptionById(beanChild.getId(), this.field, errors);
                    if (child == null || !children.contains(child)) {
                        errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.child.option.id.invalid", beanChild.getId()), ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                } else if (beanChild.getValue() != null) {
                    for (Option option : children) {
                        if (!option.getValue().equals(beanChild.getValue())) continue;
                        child = option;
                        break;
                    }
                    if (child == null) {
                        errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.child.option.value.invalid", beanChild.getValue()), ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                } else {
                    errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.child.option.parent.no.name.or.id"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
        }
        HashMap<String, Option> options = new HashMap<String, Option>();
        options.put(CascadingSelectCFType.PARENT_KEY, parent);
        if (child != null) {
            options.put("1", child);
        }
        return options;
    }

    protected Map<String, Option> getInitialValue(Issue issue, ErrorCollection errors) {
        return (Map)this.field.getValue(issue);
    }

    protected Map<String, Option> getInitialCreateValue(IssueContext issueCtx) {
        FieldConfig config = this.field.getRelevantConfig(issueCtx);
        return (Map)this.field.getCustomFieldType().getDefaultValue(config);
    }

    protected void finaliseOperation(Map<String, Option> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        if (finalValue != null) {
            if (finalValue.get(CascadingSelectCFType.PARENT_KEY) != null) {
                parameters.addCustomFieldValue(this.field.getId(), new String[]{finalValue.get(CascadingSelectCFType.PARENT_KEY).getOptionId().toString()});
            }
            if (finalValue.get("1") != null) {
                parameters.addCustomFieldValue(this.field.getId() + ":1", new String[]{finalValue.get("1").getOptionId().toString()});
            }
        } else {
            parameters.addCustomFieldValue(this.field.getId(), null);
        }
    }

    private Option findOptionById(String optionId, CustomField field, ErrorCollection errors) {
        try {
            return this.optionsManager.findByOptionId(Long.valueOf(optionId));
        }
        catch (NumberFormatException e) {
            errors.addError(field.getId(), this.i18nHelper.getText("rest.custom.field.option.id.invalid", optionId), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
    }
}

