/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentItem;
import com.atlassian.jira.issue.attachment.AttachmentItems;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsCategoriser {
    private static final Logger log = LoggerFactory.getLogger(AttachmentsCategoriser.class);
    @Nonnull
    private final Source attachmentsSource;
    @Nonnull
    private final ThumbnailManager thumbnailManager;
    private AttachmentItems attachmentItems = null;

    public AttachmentsCategoriser(ThumbnailManager thumbnailManager, Source attachmentsSource) {
        this.thumbnailManager = (ThumbnailManager)Preconditions.checkNotNull((Object)thumbnailManager);
        this.attachmentsSource = (Source)Preconditions.checkNotNull((Object)attachmentsSource);
    }

    public AttachmentItems items() {
        if (this.attachmentItems == null) {
            this.attachmentItems = new AttachmentItems(Lists.transform(this.attachmentsSource.getAttachments(), (Function)new AttachmentItemCreator()));
        }
        return this.attachmentItems;
    }

    public AttachmentItems itemsThatHaveThumbs() {
        return new AttachmentItems(Iterables.filter((Iterable)this.items(), (Predicate)new IfHasThumbnail(true)));
    }

    public AttachmentItems itemsThatDoNotHaveThumbs() {
        return new AttachmentItems(Iterables.filter((Iterable)this.items(), (Predicate)new IfHasThumbnail(false)));
    }

    public class AttachmentItemCreator
    implements Function<Attachment, AttachmentItem> {
        public AttachmentItem apply(Attachment attachment) {
            Thumbnail thumbnail = null;
            try {
                if (AttachmentsCategoriser.this.thumbnailManager.isThumbnailable(attachment)) {
                    thumbnail = AttachmentsCategoriser.this.thumbnailManager.getThumbnail(attachment);
                }
            }
            catch (GenericEntityException e) {
                log.warn("Failed to get thumbnail for {}", (Object)attachment);
            }
            return new AttachmentItem(attachment, thumbnail);
        }
    }

    static class IfHasThumbnail
    implements Predicate<AttachmentItem> {
        private final boolean hasThumbnail;

        public IfHasThumbnail(boolean hasThumbnail) {
            this.hasThumbnail = hasThumbnail;
        }

        public boolean apply(AttachmentItem item) {
            return item.isThumbnailAvailable() == this.hasThumbnail;
        }
    }

    static class AttachmentGetter
    implements Function<AttachmentItem, Attachment> {
        AttachmentGetter() {
        }

        public Attachment apply(AttachmentItem item) {
            return item.attachment;
        }
    }

    public static interface Source {
        public List<Attachment> getAttachments();
    }
}

