/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupOverviewBuilder;
import com.atlassian.jira.imports.project.core.BackupOverviewImpl;
import com.atlassian.jira.imports.project.core.BackupProjectImpl;
import com.atlassian.jira.imports.project.core.BackupSystemInformationImpl;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.populator.BackupOverviewPopulator;
import com.atlassian.jira.imports.project.populator.CustomFieldPopulator;
import com.atlassian.jira.imports.project.populator.IssueIdPopulator;
import com.atlassian.jira.imports.project.populator.PluginVersionPopulator;
import com.atlassian.jira.imports.project.populator.ProjectComponentPopulator;
import com.atlassian.jira.imports.project.populator.ProjectPopulator;
import com.atlassian.jira.imports.project.populator.ProjectVersionPopulator;
import com.atlassian.jira.imports.project.populator.SystemInfoPopulator;
import com.atlassian.jira.plugin.PluginVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class BackupOverviewBuilderImpl
implements BackupOverviewBuilder {
    private final List projects = new ArrayList();
    private final List pluginVersions = new ArrayList();
    private final Map issueIds;
    private final Map issueIdToKeyMap;
    private final Map versions = new MultiValueMap();
    private final Map components = new MultiValueMap();
    private final List overviewPopulators;
    private final List customFields;
    private final MultiMap configurationContexts;
    private final MultiMap fieldConfigSchemeIssueTypes;
    private String buildNumber;
    private String edition;
    private boolean unassignedIssuesAllowed;
    private int entityCount = 0;

    public BackupOverviewBuilderImpl() {
        this.issueIds = new MultiValueMap();
        this.issueIdToKeyMap = new HashMap();
        this.customFields = new ArrayList();
        this.configurationContexts = new MultiValueMap();
        this.fieldConfigSchemeIssueTypes = new MultiValueMap();
        this.overviewPopulators = new ArrayList();
        this.registerOverviewPopulators();
    }

    @Override
    public void addProject(ExternalProject project) {
        this.projects.add(project);
    }

    @Override
    public void addPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersions.add(pluginVersion);
    }

    @Override
    public void addVersion(ExternalVersion version) {
        this.versions.put(version.getProjectId(), version);
    }

    @Override
    public void addComponent(ExternalComponent component) {
        this.components.put(component.getProjectId(), component);
    }

    @Override
    public void addIssue(ExternalIssue issue) {
        this.issueIds.put(issue.getProject(), new Long(issue.getId()));
        this.issueIdToKeyMap.put(issue.getId(), issue.getKey());
    }

    @Override
    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public void setEdition(String edition) {
        this.edition = edition;
    }

    @Override
    public void setUnassignedIssuesAllowed(boolean unassignedIssuesAllowed) {
        this.unassignedIssuesAllowed = unassignedIssuesAllowed;
    }

    @Override
    public BackupOverview getBackupOverview() {
        BackupSystemInformationImpl backupSystemInformation = new BackupSystemInformationImpl(this.getBuildNumber(), this.getEdition(), this.getPluginVersions(), this.unassignedIssuesAllowed(), this.issueIdToKeyMap, this.entityCount);
        return new BackupOverviewImpl(backupSystemInformation, this.getProjects());
    }

    private boolean unassignedIssuesAllowed() {
        return this.unassignedIssuesAllowed;
    }

    @Override
    public void populateInformationFromElement(String elementName, Map attributes) throws ParseException {
        ++this.entityCount;
        for (BackupOverviewPopulator populator : this.overviewPopulators) {
            populator.populate(this, elementName, attributes);
        }
    }

    @Override
    public void addExternalCustomField(ExternalCustomField externalCustomField) {
        this.customFields.add(externalCustomField);
    }

    @Override
    public void addConfigurationContext(ConfigurationContext configuration) {
        this.configurationContexts.put((Object)configuration.getCustomFieldId(), (Object)configuration);
    }

    @Override
    public void addFieldConfigSchemeIssueType(FieldConfigSchemeIssueType fieldConfigSchemeIssueType) {
        this.fieldConfigSchemeIssueTypes.put((Object)fieldConfigSchemeIssueType.getFieldConfigScheme(), (Object)fieldConfigSchemeIssueType);
    }

    protected void registerOverviewPopulators() {
        this.registerOverviewPopulator(new ProjectPopulator());
        this.registerOverviewPopulator(new ProjectComponentPopulator());
        this.registerOverviewPopulator(new ProjectVersionPopulator());
        this.registerOverviewPopulator(new CustomFieldPopulator());
        this.registerOverviewPopulator(new PluginVersionPopulator());
        this.registerOverviewPopulator(new IssueIdPopulator());
        this.registerOverviewPopulator(new SystemInfoPopulator());
    }

    protected void registerOverviewPopulator(BackupOverviewPopulator populator) {
        this.overviewPopulators.add(populator);
    }

    List getProjects() {
        ArrayList<BackupProjectImpl> fullProjects = new ArrayList<BackupProjectImpl>();
        for (ExternalProject externalProject : this.projects) {
            List issueIds;
            List components;
            List versions = (List)this.versions.get(externalProject.getId());
            if (versions == null) {
                versions = Collections.EMPTY_LIST;
            }
            if ((components = (List)this.components.get(externalProject.getId())) == null) {
                components = Collections.EMPTY_LIST;
            }
            if ((issueIds = (List)this.issueIds.get(externalProject.getId())) == null) {
                issueIds = Collections.EMPTY_LIST;
            }
            List customFieldConfigs = this.getCustomFieldConfigurations(externalProject.getId());
            fullProjects.add(new BackupProjectImpl(externalProject, versions, components, customFieldConfigs, issueIds));
        }
        return fullProjects;
    }

    List getCustomFieldConfigurations(String projectId) {
        ArrayList<ExternalCustomFieldConfiguration> externalCustomFieldConfigurationList = new ArrayList<ExternalCustomFieldConfiguration>();
        for (ExternalCustomField externalCustomField : this.customFields) {
            ConfigurationContext configurationContext = this.getRelevantConfiguratonContext(projectId, externalCustomField.getId());
            if (configurationContext == null) continue;
            List fieldConfigIssueTypes = (List)this.fieldConfigSchemeIssueTypes.get((Object)configurationContext.getConfigSchemeId());
            List issuesTypes = this.getIssueTypesList(fieldConfigIssueTypes);
            externalCustomFieldConfigurationList.add(new ExternalCustomFieldConfiguration(issuesTypes, configurationContext.getProjectId(), externalCustomField, configurationContext.getConfigSchemeId()));
        }
        return externalCustomFieldConfigurationList;
    }

    private ConfigurationContext getRelevantConfiguratonContext(String projectId, String customFieldId) {
        List configContexts = (List)this.configurationContexts.get((Object)customFieldId);
        if (configContexts == null) {
            return null;
        }
        ConfigurationContext globalContext = null;
        for (ConfigurationContext configurationContext : configContexts) {
            if (configurationContext.getProjectId() == null) {
                globalContext = configurationContext;
                continue;
            }
            if (!configurationContext.getProjectId().equals(projectId)) continue;
            return configurationContext;
        }
        return globalContext;
    }

    private List getIssueTypesList(List fieldConfigIssueTypes) {
        ArrayList<String> ids = new ArrayList<String>();
        for (FieldConfigSchemeIssueType fieldConfigSchemeIssueType : fieldConfigIssueTypes) {
            String type = fieldConfigSchemeIssueType.getIssueType();
            if (type == null) {
                return null;
            }
            ids.add(type);
        }
        return ids;
    }

    List getPluginVersions() {
        return this.pluginVersions;
    }

    String getBuildNumber() {
        return this.buildNumber;
    }

    String getEdition() {
        return this.edition;
    }

    public static class FieldConfigSchemeIssueType {
        private final String fieldConfigScheme;
        private final String issueType;

        public FieldConfigSchemeIssueType(String fieldConfigScheme, String issueType) {
            this.fieldConfigScheme = fieldConfigScheme;
            this.issueType = issueType;
        }

        public String getFieldConfigScheme() {
            return this.fieldConfigScheme;
        }

        public String getIssueType() {
            return this.issueType;
        }
    }

    public static class ConfigurationContext {
        private final String projectId;
        private final String customFieldId;
        private final String configSchemeId;

        public ConfigurationContext(String configSchemeId, String customFieldId, String projectId) {
            this.configSchemeId = configSchemeId;
            this.customFieldId = customFieldId;
            this.projectId = projectId;
        }

        public String getConfigSchemeId() {
            return this.configSchemeId;
        }

        public String getCustomFieldId() {
            return this.customFieldId;
        }

        public String getProjectId() {
            return this.projectId;
        }
    }
}

