/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LabelledComponent
extends JPanel {
    private final JLabel label;
    private final JComponent component;

    public LabelledComponent(String labelText, JComponent component) {
        this.setLayout(new BorderLayout(4, 0));
        this.label = new JLabel(labelText);
        this.component = component;
        this.add((Component)this.label, "Center");
        this.add((Component)component, "East");
    }

    public String label() {
        return this.label.getText();
    }

    public boolean isUsingDefault() {
        return false;
    }

    public int getPreferredLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    public void setLabelWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, this.label.getPreferredSize().height));
    }

    public void setValue(Object newValue) {
        if (this.component instanceof JTextField) {
            ((JTextField)this.component).setText(newValue != null ? newValue.toString() : "");
            return;
        }
        if (this.component instanceof JCheckBox) {
            ((JCheckBox)this.component).setSelected(newValue instanceof Boolean ? (Boolean)newValue : false);
            return;
        }
        throw new IllegalStateException("Unexpected component class: " + this.component.getClass().getName());
    }

    public String getValue() {
        if (this.isUsingDefault()) {
            return null;
        }
        if (this.component instanceof JTextField) {
            return ((JTextField)this.component).getText();
        }
        if (this.component instanceof JCheckBox) {
            return ((JCheckBox)this.component).isSelected() ? "true" : "false";
        }
        throw new IllegalStateException("Unexpected component class: " + this.component.getClass().getName());
    }
}

