/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.configurator.config.ComplexConfigurationReason;
import com.atlassian.jira.configurator.config.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public enum WebServerProfile {
    Disabled(false, false, "Disabled", new ComplexConfigurationReason[0]),
    HttpOnly(true, false, "HTTP only", ComplexConfigurationReason.MultipleHttpConnectors),
    HttpRedirectedToHttps(true, true, "HTTP and HTTPs (redirect HTTP to HTTPs)", ComplexConfigurationReason.AnotherSecurityConstraintExisting, ComplexConfigurationReason.MultipleHttpConnectors, ComplexConfigurationReason.MultipleHttpsConnectors, ComplexConfigurationReason.SslEnabledAprConnector),
    HttpsOnly(false, true, "HTTPs only", ComplexConfigurationReason.MultipleHttpsConnectors, ComplexConfigurationReason.SslEnabledAprConnector);

    private final boolean httpEnabled;
    private final boolean httpsEnabled;
    private final String label;
    private final List<ComplexConfigurationReason> problems;

    private WebServerProfile(@Nonnull boolean httpEnabled, @Nonnull boolean httpsEnabled, String label, ComplexConfigurationReason ... problems) {
        this.httpEnabled = httpEnabled;
        this.httpsEnabled = httpsEnabled;
        this.label = label;
        this.problems = Arrays.asList(problems);
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    public boolean isPreventedBy(@Nonnull List<ComplexConfigurationReason> complexConfigurationReasons) {
        return !Collections.disjoint(this.problems, complexConfigurationReasons);
    }

    public static WebServerProfile retrieveByFlags(boolean httpEnabled, boolean httpsEnabled) {
        for (WebServerProfile profile : WebServerProfile.values()) {
            if (profile.httpEnabled != httpEnabled || profile.httpsEnabled != httpsEnabled) continue;
            return profile;
        }
        throw new IllegalArgumentException("unknown profile with httpEnabled " + httpEnabled + " and httpsEnabled " + httpsEnabled);
    }

    @Nonnull
    public static List<WebServerProfile> getUsableProfiles(@Nonnull Settings settings) {
        WebServerProfile[] allProfiles = WebServerProfile.values();
        List<ComplexConfigurationReason> complexConfigurationReasons = settings.getComplexConfigurationReasons();
        ArrayList<WebServerProfile> result = new ArrayList<WebServerProfile>(allProfiles.length);
        for (WebServerProfile profile : allProfiles) {
            if (profile.isPreventedBy(complexConfigurationReasons)) continue;
            result.add(profile);
        }
        return result;
    }
}

