/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.config.properties.ExampleGenerator;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.validation.ApplicationPropertyEnumerator;
import com.atlassian.validation.EnumValidator;
import com.atlassian.validation.Validator;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

class MetadataLoader {
    private static final Logger log = Logger.getLogger(MetadataLoader.class);

    MetadataLoader() {
    }

    LinkedHashMap<String, ApplicationPropertyMetadata> loadMetadata(String xmlFilename) throws DataAccessException {
        try {
            log.debug((Object)("Loading application properties metadata from " + xmlFilename));
            InputStream mxml = this.getClass().getClassLoader().getResourceAsStream(xmlFilename);
            return this.loadMetadata(mxml, xmlFilename);
        }
        catch (Exception e) {
            throw new DataAccessException("Cannot load the application properties metadata file " + xmlFilename, (Throwable)e);
        }
    }

    LinkedHashMap<String, ApplicationPropertyMetadata> loadMetadata(InputStream stream, String streamDescriptor) throws DocumentException {
        LinkedHashMap<String, ApplicationPropertyMetadata> metadataMap = new LinkedHashMap<String, ApplicationPropertyMetadata>();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(stream);
        Element root = doc.getRootElement();
        Iterator properties = root.element("properties").elementIterator();
        while (properties.hasNext()) {
            boolean sysAdminEditable;
            Element enm;
            Element typeElement;
            Element property = (Element)properties.next();
            String key = property.elementText("key");
            String defaultValue = property.elementText("default-value");
            String type = property.elementText("type");
            if (type == null) {
                type = "string";
            }
            String validator = property.elementText("validator");
            Supplier validatorObject = null;
            HashMap enumerators = Maps.newHashMap();
            if (StringUtils.isBlank((String)type) && (typeElement = property.element("type")) != null && (enm = typeElement.element("enum")) != null) {
                type = "enum";
                ArrayList<String> options = new ArrayList<String>();
                Iterator optionIter = enm.elementIterator("option");
                while (optionIter.hasNext()) {
                    Element optionElem = (Element)optionIter.next();
                    String optionValue = optionElem.getText();
                    if (optionValue == null || "".equals(optionValue.trim())) {
                        throw new IllegalArgumentException("No option may be blank");
                    }
                    options.add(optionValue);
                }
                enumerators.put(key, ApplicationPropertyEnumerator.of(options));
                validatorObject = Suppliers.ofInstance((Object)new EnumValidator((ApplicationPropertyEnumerator)enumerators.get(key)));
            }
            String name = property.elementText("name");
            String nameKey = property.elementText("nameKey");
            String desc = property.elementText("description");
            String descKey = property.elementText("descriptionKey");
            if (name == null && nameKey == null) {
                name = key;
            }
            boolean bl = sysAdminEditable = !"false".equalsIgnoreCase(property.elementText("sysadmin-editable"));
            if (!sysAdminEditable) {
                sysAdminEditable = !"false".equalsIgnoreCase(property.elementText("sysadmin-editable"));
            }
            boolean requiresRestart = !"false".equalsIgnoreCase(property.elementText("requires-restart"));
            boolean adminEditable = !"false".equalsIgnoreCase(property.elementText("admin-editable"));
            ExampleGenerator exampleGenerator = null;
            Pair requiredFeatureKey = null;
            if (property.element("feature-key") != null) {
                Element featureKey = property.element("feature-key");
                Boolean featureEnabled = Boolean.TRUE;
                if (featureKey.attribute("enabled") != null) {
                    featureEnabled = Boolean.parseBoolean(featureKey.attribute("enabled").getText());
                }
                requiredFeatureKey = Pair.nicePairOf((Object)featureKey.getText(), (Object)featureEnabled);
            }
            if (property.elementText("example-generator") != null) {
                try {
                    exampleGenerator = (ExampleGenerator)Class.forName(property.elementText("example-generator")).newInstance();
                }
                catch (ClassNotFoundException e) {
                    log.debug((Object)("Couldn't find example generator class for: " + name));
                }
                catch (InstantiationException e) {
                    log.debug((Object)("Couldn't create instance of example generator class for: " + name));
                }
                catch (IllegalAccessException e) {
                    log.debug((Object)("Illegal access to example generator class for: " + name));
                }
                catch (ClassCastException e) {
                    log.debug((Object)("Example generator class for: " + name + "doesn't implement the ExampleGenerator interface"));
                }
            }
            if (key != null) {
                ApplicationPropertyMetadata.Builder builder = new ApplicationPropertyMetadata.Builder().key(key).type(type).defaultValue(defaultValue).adminEditable(adminEditable).sysAdminEditable(sysAdminEditable).requiresRestart(requiresRestart).name(name).nameKey(nameKey).desc(desc).descKey(descKey).exampleGenerator(exampleGenerator).requiredFeatureKey((Pair<String, Boolean>)requiredFeatureKey).enumerator((ApplicationPropertyEnumerator)enumerators.get(key));
                if (validatorObject == null) {
                    builder.validatorName(validator);
                } else {
                    builder.validator((Supplier<? extends Validator>)validatorObject);
                }
                metadataMap.put(key, builder.build());
                continue;
            }
            log.error((Object)(streamDescriptor + " contains null key"));
        }
        return metadataMap;
    }
}

