/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.jira.appconsistency.db.PostgresSchemaConfigCheck;
import com.atlassian.jira.appconsistency.db.PublicSchemaConfigCheck;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ofbiz.core.entity.config.DatasourceInfo;

public final class DatabaseConfig {
    public static final String DEFAULT_DATASOURCE_NAME = "defaultDS";
    public static final String DEFAULT_DELEGATOR_NAME = "default";
    private final String datasourceName;
    private final String delegatorName;
    private final String databaseType;
    private final String schemaName;
    private final Datasource datasource;

    public DatabaseConfig(String databaseType, String schemaName, Datasource datasource) {
        this(DEFAULT_DATASOURCE_NAME, DEFAULT_DELEGATOR_NAME, databaseType, schemaName, datasource);
    }

    public DatabaseConfig(String datasourceName, String delegatorName, String databaseType, String schemaName, Datasource datasource) {
        this.datasourceName = Assertions.notBlank((String)"Datasource name", (String)datasourceName);
        this.delegatorName = Assertions.notBlank((String)"Delegator name", (String)delegatorName);
        this.databaseType = Assertions.notBlank((String)"Database type", (String)databaseType);
        this.schemaName = schemaName;
        this.datasource = (Datasource)Assertions.notNull((String)"Datasource", (Object)datasource);
    }

    public StartupCheck testConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        Supplier dsi = Suppliers.ofInstance((Object)this.getDatasourceInfo());
        PostgresSchemaConfigCheck postgresCheck = new PostgresSchemaConfigCheck((Supplier<DatasourceInfo>)dsi, new ExternalLinkUtilImpl());
        PublicSchemaConfigCheck schemaCheck = new PublicSchemaConfigCheck((Supplier<DatasourceInfo>)dsi);
        StartupCheck failedCheck = null;
        if (!postgresCheck.isOk()) {
            failedCheck = postgresCheck;
        } else if (!schemaCheck.isOk()) {
            failedCheck = schemaCheck;
        }
        this.datasource.getConnection(bootstrapManager);
        return failedCheck;
    }

    public boolean isDatabaseEmpty(DefaultAtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        Connection conn = this.datasource.getConnection((AtlassianBootstrapManager)bootstrapManager);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            String[] types = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
            String lookupSchemaName = this.lookupSchemaName(metaData);
            ResultSet tableSet = metaData.getTables(null, lookupSchemaName, null, types);
            return tableSet == null || !tableSet.next();
        }
        catch (SQLException e) {
            throw new BootstrapException((Throwable)e);
        }
    }

    private String lookupSchemaName(DatabaseMetaData metaData) throws SQLException {
        String lookupSchemaName = null;
        DatasourceInfo datasourceInfo = this.getDatasourceInfo();
        if (metaData.supportsSchemasInTableDefinitions()) {
            lookupSchemaName = datasourceInfo.getSchemaName() != null && datasourceInfo.getSchemaName().length() > 0 ? datasourceInfo.getSchemaName() : metaData.getUserName();
        }
        return lookupSchemaName;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public String getDelegatorName() {
        return this.delegatorName;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public boolean isHSql() {
        return this.databaseType.startsWith("hsql");
    }

    public boolean isMySql() {
        return this.databaseType.startsWith("mysql");
    }

    public boolean isOracle() {
        return this.databaseType.startsWith("oracle");
    }

    public boolean isPostgres() {
        return this.databaseType.startsWith("postgres");
    }

    public boolean isSqlServer() {
        return this.databaseType.startsWith("mssql");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Datasource getDatasource() {
        return this.datasource;
    }

    public DatasourceInfo getDatasourceInfo() {
        return this.datasource.getDatasource(this.datasourceName, this.databaseType, this.schemaName);
    }

    public String getDescriptorValue() {
        return this.datasource.getDescriptorValue(this.databaseType);
    }

    public String getDescriptorLabel() {
        return this.datasource.getDescriptorLabel();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

