/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.jira.cache.HashRegistryCache;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzDetector;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.modzdetector.ResourceAccessor;
import java.io.InputStream;
import java.lang.ref.SoftReference;

public class HashRegistryCacheImpl
implements HashRegistryCache {
    private final ModzDetector detector;
    private SoftReference<Modifications> ref;

    public HashRegistryCacheImpl() {
        this(new ModzDetector(new ResourceAccessor(){

            public InputStream getResourceFromClasspath(String resourceName) {
                if (resourceName.charAt(0) != '/') {
                    resourceName = "/" + resourceName;
                }
                return this.getResourceByPath("/WEB-INF/classes" + resourceName);
            }

            public InputStream getResourceByPath(String resourceName) {
                if (resourceName.charAt(0) != '/') {
                    resourceName = "/" + resourceName;
                }
                return ServletContextProvider.getServletContext().getResourceAsStream(resourceName);
            }
        }), new SoftReference<Object>(null));
    }

    HashRegistryCacheImpl(ModzDetector detector, SoftReference<Modifications> r) {
        this.detector = detector;
        this.ref = r;
    }

    @Override
    public synchronized Modifications getModifications() throws ModzRegistryException {
        Modifications mods = this.ref.get();
        if (mods == null) {
            mods = this.detector.getModifiedFiles();
            this.ref = new SoftReference<Modifications>(mods);
        }
        return mods;
    }
}

