/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Objects;
import java.util.Map;
import javax.annotation.Nonnull;

public class DefaultWorkflowSchemeService
implements WorkflowSchemeService {
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18Factory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final IssueTypeManager issueTypeManager;

    public DefaultWorkflowSchemeService(PermissionManager permissionManager, I18nHelper.BeanFactory i18Factory, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, IssueTypeManager issueTypeManager) {
        this.permissionManager = permissionManager;
        this.i18Factory = i18Factory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.issueTypeManager = issueTypeManager;
    }

    public AssignableWorkflowScheme.Builder assignableBuilder() {
        return this.workflowSchemeManager.assignableBuilder();
    }

    public DraftWorkflowScheme.Builder draftBuilder(AssignableWorkflowScheme parent) {
        Assertions.notNull((String)"parent", (Object)parent);
        Assertions.notNull((String)"parent.id", (Object)parent.getId());
        return this.workflowSchemeManager.draftBuilder(parent);
    }

    @Nonnull
    public ServiceOutcome<AssignableWorkflowScheme> createScheme(ApplicationUser creator, @Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Object outcome = this.checkEditPermission(creator);
        if (!outcome.isValid()) {
            return outcome;
        }
        outcome = this.validateAssignable(creator, scheme, true);
        if (!outcome.isValid()) {
            return outcome;
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.createScheme(scheme));
    }

    public ServiceOutcome<DraftWorkflowScheme> createDraft(ApplicationUser creator, long parentId) {
        ServiceOutcome<AssignableWorkflowScheme> parentOutcome = this.validateCreateDraft(creator, parentId);
        if (!parentOutcome.isValid()) {
            return ServiceOutcomeImpl.error(parentOutcome);
        }
        DraftWorkflowScheme draft = this.workflowSchemeManager.createDraftOf(creator, (AssignableWorkflowScheme)parentOutcome.getReturnedValue());
        return ServiceOutcomeImpl.ok(draft);
    }

    public ServiceOutcome<DraftWorkflowScheme> createDraft(ApplicationUser creator, DraftWorkflowScheme draftWorkflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)draftWorkflowScheme);
        AssignableWorkflowScheme parentScheme = draftWorkflowScheme.getParentScheme();
        Assertions.notNull((String)"workflowScheme.parentScheme", (Object)parentScheme);
        Assertions.notNull((String)"workflowScheme.parentScheme.id", (Object)parentScheme.getId());
        ServiceOutcome<AssignableWorkflowScheme> parentOutcome = this.validateCreateDraft(creator, parentScheme.getId());
        if (!parentOutcome.isValid()) {
            return ServiceOutcomeImpl.error(parentOutcome);
        }
        ServiceOutcome outcome = this.validateMappings(creator, (WorkflowScheme)draftWorkflowScheme);
        if (!outcome.isValid()) {
            return outcome;
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.createDraft(creator, draftWorkflowScheme));
    }

    private ServiceOutcome<AssignableWorkflowScheme> validateCreateDraft(ApplicationUser creator, long parentId) {
        Object outcome = this.checkEditPermission(creator);
        if (!outcome.isValid()) {
            return outcome;
        }
        outcome = this.getWorkflowSchemeNoPermissionCheck(creator, parentId);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.from(outcome.getErrorCollection(), null);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)outcome.getReturnedValue();
        if (!this.workflowSchemeManager.isActive((WorkflowScheme)workflowScheme)) {
            return this.getError(creator, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.not.active");
        }
        if (this.workflowSchemeManager.hasDraft(workflowScheme)) {
            return this.getError(creator, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.has.draft");
        }
        return outcome;
    }

    public ServiceOutcome<AssignableWorkflowScheme> getWorkflowScheme(ApplicationUser user, long id) {
        ServiceOutcome outcome = this.checkViewPermission(user);
        if (!outcome.isValid()) {
            return outcome;
        }
        return this.getWorkflowSchemeNoPermissionCheck(user, id);
    }

    public ServiceOutcome<DraftWorkflowScheme> getDraftWorkflowScheme(ApplicationUser user, @Nonnull AssignableWorkflowScheme parentScheme) {
        Assertions.notNull((String)"scheme", (Object)parentScheme);
        return ServiceOutcomeImpl.ok(!parentScheme.isDefault() ? this.workflowSchemeManager.getDraftForParent(parentScheme) : null);
    }

    public ServiceOutcome<DraftWorkflowScheme> getDraftWorkflowSchemeNotNull(ApplicationUser user, @Nonnull AssignableWorkflowScheme parentScheme) {
        ServiceOutcome<DraftWorkflowScheme> result = this.getDraftWorkflowScheme(user, parentScheme);
        if (!result.isValid() || result.getReturnedValue() != null) {
            return result;
        }
        return this.getError(user, ErrorCollection.Reason.NOT_FOUND, "admin.workflowschemes.service.error.no.draft");
    }

    public ServiceOutcome<Void> deleteWorkflowScheme(ApplicationUser user, @Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        ServiceOutcome outcome = this.checkEditPermission(user);
        if (!outcome.isValid()) {
            return outcome;
        }
        Object existsOutcome = scheme.isDraft() ? this.getDraftSchemeNoPermissionCheck(user, scheme.getId()) : this.getWorkflowSchemeNoPermissionCheck(user, scheme.getId());
        if (!existsOutcome.isValid()) {
            return DefaultWorkflowSchemeService.convert(existsOutcome);
        }
        if (scheme.isDefault()) {
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.cant.delete.default");
        }
        if (this.isActive(scheme)) {
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.delete.active");
        }
        if (!this.workflowSchemeManager.deleteWorkflowScheme(scheme)) {
            return this.getError(user, ErrorCollection.Reason.SERVER_ERROR, "admin.workflowschemes.service.error.delete.error");
        }
        return ServiceOutcomeImpl.ok(null);
    }

    public boolean isActive(WorkflowScheme workflowScheme) {
        return this.workflowSchemeManager.isActive((WorkflowScheme)Assertions.notNull((String)"workflowScheme", (Object)workflowScheme));
    }

    public ServiceOutcome<AssignableWorkflowScheme> getSchemeForProject(ApplicationUser user, @Nonnull Project project) {
        if (!this.hasPermissionToEditProject(user, project)) {
            return this.getError(user, ErrorCollection.Reason.FORBIDDEN, "admin.workflowschemes.service.error.no.permission.project");
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.getWorkflowSchemeObj(project));
    }

    public ServiceOutcome<AssignableWorkflowScheme> updateWorkflowScheme(ApplicationUser user, @Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        ServiceOutcome<Void> outcome = this.validateUpdateWorkflowScheme(user, scheme);
        if (!outcome.isValid()) {
            return DefaultWorkflowSchemeService.error(outcome);
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.updateWorkflowScheme(scheme));
    }

    public ServiceOutcome<Void> validateUpdateWorkflowScheme(ApplicationUser user, @Nonnull AssignableWorkflowScheme scheme) {
        Object outcome = this.checkEditPermission(user);
        if (!outcome.isValid()) {
            return DefaultWorkflowSchemeService.error(outcome);
        }
        outcome = this.getWorkflowSchemeNoPermissionCheck(user, scheme.getId());
        if (!outcome.isValid()) {
            return DefaultWorkflowSchemeService.error(outcome);
        }
        AssignableWorkflowScheme currentScheme = (AssignableWorkflowScheme)outcome.getReturnedValue();
        outcome = this.validateAssignable(user, scheme, false);
        if (!outcome.isValid()) {
            return DefaultWorkflowSchemeService.error(outcome);
        }
        if (this.isActive((WorkflowScheme)currentScheme) && !Objects.equal((Object)scheme.getMappings(), (Object)currentScheme.getMappings())) {
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.change.active");
        }
        return DefaultWorkflowSchemeService.error(outcome);
    }

    private static <T> ServiceOutcome<T> error(ServiceOutcome<?> outcome) {
        return ServiceOutcomeImpl.from(outcome.getErrorCollection(), null);
    }

    public ServiceOutcome<DraftWorkflowScheme> updateWorkflowScheme(ApplicationUser user, @Nonnull DraftWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Object outcome = this.checkEditPermission(user);
        if (!outcome.isValid()) {
            return outcome;
        }
        outcome = this.getDraftSchemeNoPermissionCheck(user, scheme.getId());
        if (!outcome.isValid()) {
            return outcome;
        }
        outcome = this.validateMappings(user, (WorkflowScheme)scheme);
        if (!outcome.isValid()) {
            return outcome;
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.updateDraftWorkflowScheme(user, scheme));
    }

    public int getUsageCount(@Nonnull AssignableWorkflowScheme assignableWorkflowScheme) {
        return this.workflowSchemeManager.getProjectsUsing(assignableWorkflowScheme).size();
    }

    public boolean isUsingDefaultScheme(@Nonnull Project project) {
        return this.workflowSchemeManager.isUsingDefaultScheme(project);
    }

    boolean hasPermissionToEditProject(ApplicationUser user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, (User)user, project);
    }

    private <T> ServiceOutcome<T> getError(ApplicationUser user, ErrorCollection.Reason reason, String key) {
        String text = this.i18Factory.getInstance((User)user).getText(key);
        return this.outcomeForReason(reason, text);
    }

    private <T> ServiceOutcome<T> getError(ApplicationUser user, ErrorCollection.Reason reason, String key, String arg) {
        String text = this.i18Factory.getInstance((User)user).getText(key, arg);
        return this.outcomeForReason(reason, text);
    }

    private <T> ServiceOutcome<T> outcomeForReason(ErrorCollection.Reason reason, String text) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage(text);
        simpleErrorCollection.addReason(reason);
        return ServiceOutcomeImpl.from((ErrorCollection)simpleErrorCollection, null);
    }

    private boolean hasAdminPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, (User)user);
    }

    private ServiceOutcome<AssignableWorkflowScheme> validateAssignable(ApplicationUser user, AssignableWorkflowScheme scheme, boolean creating) {
        if (scheme.getName() == null) {
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.scheme.must.have.name");
        }
        if (scheme.getName().length() > 255) {
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.scheme.name.too.big");
        }
        AssignableWorkflowScheme oldScheme = this.workflowSchemeManager.getWorkflowSchemeObj(scheme.getName());
        if (oldScheme != null && (creating || !oldScheme.getId().equals(scheme.getId()))) {
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.scheme.name.duplicate", scheme.getName());
        }
        return this.validateMappings(user, (WorkflowScheme)scheme);
    }

    private <T extends WorkflowScheme> ServiceOutcome<T> validateMappings(ApplicationUser user, WorkflowScheme scheme) {
        for (Map.Entry stringEntry : scheme.getMappings().entrySet()) {
            String issueType = (String)stringEntry.getKey();
            String workflowName = (String)stringEntry.getValue();
            if (issueType != null && this.issueTypeManager.getIssueType(issueType) == null) {
                return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.invalid.issue.type", issueType);
            }
            if (workflowName != null && this.workflowManager.getWorkflow(workflowName) != null) continue;
            return this.getError(user, ErrorCollection.Reason.VALIDATION_FAILED, "admin.workflowschemes.service.error.bad.workflow", workflowName == null ? "<null>" : workflowName);
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private <T> ServiceOutcome<T> checkEditPermission(ApplicationUser user) {
        if (!this.hasAdminPermission(user)) {
            return this.getError(user, ErrorCollection.Reason.FORBIDDEN, "admin.workflowschemes.service.error.no.admin.permission");
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private <T> ServiceOutcome<T> checkViewPermission(ApplicationUser user) {
        if (!this.hasAdminPermission(user)) {
            return this.getError(user, ErrorCollection.Reason.FORBIDDEN, "admin.workflowschemes.service.error.no.view.permission");
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private ServiceOutcome<AssignableWorkflowScheme> getWorkflowSchemeNoPermissionCheck(ApplicationUser user, long id) {
        AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowScheme == null) {
            return this.getError(user, ErrorCollection.Reason.NOT_FOUND, "admin.workflowschemes.service.error.does.not.exist");
        }
        return ServiceOutcomeImpl.ok(workflowScheme);
    }

    private ServiceOutcome<DraftWorkflowScheme> getDraftSchemeNoPermissionCheck(ApplicationUser user, long id) {
        DraftWorkflowScheme workflowScheme = this.workflowSchemeManager.getDraft(id);
        if (workflowScheme == null) {
            return this.getError(user, ErrorCollection.Reason.NOT_FOUND, "admin.workflowschemes.service.error.draft.does.not.exist");
        }
        return ServiceOutcomeImpl.ok(workflowScheme);
    }

    private static <T> ServiceOutcome<T> convert(ServiceOutcome<?> errors) {
        return ServiceOutcomeImpl.from(errors.getErrorCollection(), null);
    }
}

