/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.QueryCache;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.RelevantSearcherVisitor;
import com.atlassian.jira.issue.search.searchers.util.TerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.context.QueryContextImpl;
import com.atlassian.jira.jql.context.QueryContextVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.parser.JqlParseErrorMessage;
import com.atlassian.jira.jql.parser.JqlParseErrorMessages;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.permission.ClauseSanitisingVisitor;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.jql.validator.OrderByValidator;
import com.atlassian.jira.jql.validator.ValidatorVisitor;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.order.OrderBy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultSearchService
implements SearchService {
    private static final Logger log = Logger.getLogger(DefaultSearchService.class);
    private final JqlQueryParser jqlQueryParser;
    private final JqlStringSupport jqlStringSupport;
    private final ValidatorVisitor.ValidatorVisitorFactory validatorVisitorFactory;
    private final SearchHandlerManager searchHandlerManager;
    private final QueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory;
    private final QueryContextConverter queryContextConverter;
    private final QueryCache queryCache;
    private final JqlOperandResolver jqlOperandResolver;
    private final OrderByValidator orderByValidator;
    private final SearchProvider searchProvider;
    private final I18nHelper.BeanFactory factory;

    public DefaultSearchService(SearchHandlerManager searchHandlerManager, JqlQueryParser jqlQueryParser, ValidatorVisitor.ValidatorVisitorFactory validatorVisitorFactory, QueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory, JqlStringSupport jqlStringSupport, QueryContextConverter queryContextConverter, QueryCache queryCache, JqlOperandResolver jqlOperandResolver, OrderByValidator orderByValidator, SearchProvider searchProvider, I18nHelper.BeanFactory factory) {
        this.factory = factory;
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.queryCache = (QueryCache)Assertions.notNull((String)"queryCache", (Object)queryCache);
        this.queryContextConverter = (QueryContextConverter)Assertions.notNull((String)"queryContextConverter", (Object)queryContextConverter);
        this.queryContextVisitorFactory = (QueryContextVisitor.QueryContextVisitorFactory)Assertions.notNull((String)"queryContextVisitorFactory", (Object)queryContextVisitorFactory);
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
        this.jqlQueryParser = (JqlQueryParser)Assertions.notNull((String)"jqlQueryParser", (Object)jqlQueryParser);
        this.jqlStringSupport = (JqlStringSupport)Assertions.notNull((String)"jqlStringSupport", (Object)jqlStringSupport);
        this.validatorVisitorFactory = (ValidatorVisitor.ValidatorVisitorFactory)Assertions.notNull((String)"validatorVisitorFactory", (Object)validatorVisitorFactory);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.orderByValidator = (OrderByValidator)Assertions.notNull((String)"orderByValidator", (Object)orderByValidator);
    }

    public boolean doesQueryFitFilterForm(User user, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        if (query.getWhereClause() != null) {
            Boolean doesItFit = this.queryCache.getDoesQueryFitFilterFormCache(user, query);
            if (doesItFit == null) {
                doesItFit = this.calculateDoesQueryFitFilterForm(user, query);
                this.queryCache.setDoesQueryFitFilterFormCache(user, query, doesItFit);
            }
            return doesItFit;
        }
        return true;
    }

    public SearchResults search(User searcher, Query query, PagerFilter pager) throws SearchException {
        return this.searchProvider.search(query, searcher, pager);
    }

    public long searchCount(User searcher, Query query) throws SearchException {
        return this.searchProvider.searchCount(query, searcher);
    }

    public SearchContext getSearchContext(User searcher, Query query) {
        SearchContext searchContext;
        QueryContext queryContext;
        if (query != null && (queryContext = this.getSimpleQueryContext(searcher, query)) != null && (searchContext = this.queryContextConverter.getSearchContext(queryContext)) != null) {
            return searchContext;
        }
        return this.createSearchContext(Collections.<Long>emptyList(), Collections.<String>emptyList());
    }

    public String getQueryString(User user, Query query) {
        UrlBuilder url = this.createUrlBuilder();
        url.addParameter("jqlQuery", this.getJqlString(query));
        return url.asUrlString();
    }

    public SearchService.ParseResult parseQuery(User searcher, String query) {
        Assertions.notNull((String)"query", (Object)query);
        Query newQuery = null;
        MessageSetImpl errors = new MessageSetImpl();
        try {
            newQuery = this.jqlQueryParser.parseQuery(query);
        }
        catch (JqlParseException exception) {
            JqlParseErrorMessage errorMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to parse query.", (Throwable)exception);
            }
            if ((errorMessage = exception.getParseErrorMessage()) == null) {
                errorMessage = JqlParseErrorMessages.genericParseError();
            }
            errors.addErrorMessage(errorMessage.getLocalizedErrorMessage(this.getI18n(searcher)));
        }
        return new SearchService.ParseResult(newQuery, (MessageSet)errors);
    }

    public QueryContext getQueryContext(User searcher, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause == null) {
            return new QueryContextImpl(ClauseContextImpl.createGlobalClauseContext());
        }
        QueryContext queryContext = this.queryCache.getQueryContextCache(searcher, query);
        if (queryContext == null) {
            QueryContextVisitor visitor = this.queryContextVisitorFactory.createVisitor(searcher);
            QueryContextVisitor.ContextResult result = (QueryContextVisitor.ContextResult)clause.accept((ClauseVisitor)visitor);
            queryContext = new QueryContextImpl(result.getFullContext());
            QueryContextImpl explicitQueryContext = new QueryContextImpl(result.getSimpleContext());
            this.queryCache.setQueryContextCache(searcher, query, queryContext);
            this.queryCache.setSimpleQueryContextCache(searcher, query, explicitQueryContext);
        }
        return queryContext;
    }

    public QueryContext getSimpleQueryContext(User searcher, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause == null) {
            return new QueryContextImpl(ClauseContextImpl.createGlobalClauseContext());
        }
        QueryContext simpleQueryContext = this.queryCache.getSimpleQueryContextCache(searcher, query);
        if (simpleQueryContext == null) {
            QueryContextVisitor visitor = this.queryContextVisitorFactory.createVisitor(searcher);
            QueryContextVisitor.ContextResult result = (QueryContextVisitor.ContextResult)clause.accept((ClauseVisitor)visitor);
            simpleQueryContext = new QueryContextImpl(result.getSimpleContext());
            QueryContextImpl fullQueryContext = new QueryContextImpl(result.getFullContext());
            this.queryCache.setQueryContextCache(searcher, query, fullQueryContext);
            this.queryCache.setSimpleQueryContextCache(searcher, query, simpleQueryContext);
        }
        return simpleQueryContext;
    }

    public MessageSet validateQuery(User searcher, Query query) {
        MessageSetImpl messageSet;
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause != null) {
            ValidatorVisitor visitor = this.validatorVisitorFactory.createVisitor(searcher);
            messageSet = (MessageSet)clause.accept((ClauseVisitor)visitor);
        } else {
            messageSet = new MessageSetImpl();
        }
        OrderBy orderBy = query.getOrderByClause();
        if (orderBy != null) {
            messageSet.addMessageSet(this.orderByValidator.validate(searcher, orderBy));
        }
        return messageSet;
    }

    public String getJqlString(Query query) {
        Assertions.notNull((String)"query", (Object)query);
        if (query.getQueryString() != null) {
            return query.getQueryString();
        }
        return this.getGeneratedJqlString(query);
    }

    public String getGeneratedJqlString(Query query) {
        Assertions.notNull((String)"query", (Object)query);
        return this.jqlStringSupport.generateJqlString(query);
    }

    public Query sanitiseSearchQuery(User searcher, Query query) {
        Assertions.notNull((String)"query", (Object)query);
        Clause clause = query.getWhereClause();
        if (clause == null) {
            return query;
        }
        ClauseSanitisingVisitor visitor = this.createClauseSanitisingVisitor(searcher);
        Clause sanitisedClause = (Clause)clause.accept((ClauseVisitor)visitor);
        if (!clause.equals(sanitisedClause)) {
            return new QueryImpl(sanitisedClause, query.getOrderByClause(), null);
        }
        return query;
    }

    ClauseSanitisingVisitor createClauseSanitisingVisitor(User searcher) {
        return new ClauseSanitisingVisitor(this.searchHandlerManager, this.jqlOperandResolver, searcher);
    }

    SearchContext createSearchContext(List<Long> projects, List<String> issueTypes) {
        return new SearchContextImpl(Collections.emptyList(), projects, issueTypes);
    }

    I18nHelper getI18n(User user) {
        return this.factory.getInstance(user);
    }

    Set<IssueSearcher> getRelevantQuerySearchers(User user, Query query, SearchContext searchContext) {
        Assertions.notNull((String)"query", (Object)query);
        RelevantSearcherVisitor relevantSearcherVisitor = this.createRelevantSearcherVisitor(user, searchContext);
        boolean allHaveSearchers = (Boolean)query.getWhereClause().accept((ClauseVisitor)relevantSearcherVisitor);
        if (!allHaveSearchers) {
            return null;
        }
        return relevantSearcherVisitor.getRelevantSearchers();
    }

    boolean calculateDoesQueryFitFilterForm(User user, Query query) {
        boolean doesItFit = true;
        SearchContext simpleSearchContext = this.queryContextConverter.getSearchContext(this.getSimpleQueryContext(user, query));
        if (simpleSearchContext == null) {
            doesItFit = false;
        } else {
            Set<IssueSearcher> relevantSearchers = this.getRelevantQuerySearchers(user, query, simpleSearchContext);
            if (relevantSearchers == null) {
                doesItFit = false;
            } else if (!relevantSearchers.isEmpty()) {
                for (IssueSearcher relevantSearcher : relevantSearchers) {
                    SearchInputTransformer searchInputTransformer = relevantSearcher.getSearchInputTransformer();
                    if (searchInputTransformer.doRelevantClausesFitFilterForm(user, query, simpleSearchContext)) continue;
                    doesItFit = false;
                    break;
                }
                if (doesItFit) {
                    doesItFit = this.calculateDoesQueryValidationFitFilterForm(user, simpleSearchContext, query);
                }
            }
        }
        return doesItFit;
    }

    boolean calculateDoesQueryValidationFitFilterForm(User user, SearchContext searchContext, Query query) {
        ValidatorVisitor validatorVisitor = this.validatorVisitorFactory.createVisitor(user);
        TerminalClauseCollectingVisitor terminalClauseCollectingVisitor = new TerminalClauseCollectingVisitor();
        query.getWhereClause().accept((ClauseVisitor)terminalClauseCollectingVisitor);
        Collection<TerminalClause> clauses = terminalClauseCollectingVisitor.getClauses();
        for (TerminalClause clause : clauses) {
            Collection issueSearchers = this.searchHandlerManager.getSearchersByClauseName(user, clause.getName(), searchContext);
            for (IssueSearcher issueSearcher : issueSearchers) {
                if (this.checkValidationMatches(user, query, searchContext, clause, issueSearcher, validatorVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    boolean checkValidationMatches(User user, Query query, SearchContext searchContext, TerminalClause clause, IssueSearcher searcher, ClauseVisitor<MessageSet> validatorVisitor) {
        MessageSet clauseErrors = (MessageSet)clause.accept(validatorVisitor);
        if (!clauseErrors.hasAnyMessages()) {
            return true;
        }
        SearchInputTransformer transformer = searcher.getSearchInputTransformer();
        FieldValuesHolderImpl holder = new FieldValuesHolderImpl();
        transformer.populateFromQuery(user, (FieldValuesHolder)holder, query, searchContext);
        SimpleErrorCollection searcherErrors = new SimpleErrorCollection();
        transformer.validateParams(user, searchContext, (FieldValuesHolder)holder, this.getI18n(user), (ErrorCollection)searcherErrors);
        return searcherErrors.hasAnyErrors();
    }

    RelevantSearcherVisitor createRelevantSearcherVisitor(User user, SearchContext searchContext) {
        return new RelevantSearcherVisitor(this.searchHandlerManager, user, searchContext);
    }

    UrlBuilder createUrlBuilder() {
        return new UrlBuilder(true);
    }

    String encode(String s) {
        return JiraUrlCodec.encode((String)s);
    }
}

