/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.avatar.MD5Util;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarServiceImpl
implements AvatarService {
    private static final ImmutableMap<Avatar.Size, String> DEFAULT_AVATAR_PUBLIC_URL = ImmutableMap.of((Object)Avatar.Size.SMALL, (Object)"http://wpc.29c4.edgecastcdn.net/8029C4/downloads/images/jira/jira52_default_user_avatar_16px.png", (Object)Avatar.Size.LARGE, (Object)"http://wpc.29c4.edgecastcdn.net/8029C4/downloads/images/jira/jira52_default_user_avatar_48px.png");
    private final Logger log = LoggerFactory.getLogger(AvatarServiceImpl.class);
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final UserPropertyManager userPropertyManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final LazyReference<Avatar.Size> defaultAvatarSize = new LazyReference<Avatar.Size>(){

        protected Avatar.Size create() throws Exception {
            for (Avatar.Size size : Avatar.Size.values()) {
                if (!size.isDefault) continue;
                return size;
            }
            return Avatar.Size.LARGE;
        }
    };

    public AvatarServiceImpl(UserManager userManager, AvatarManager avatarManager, UserPropertyManager userPropertyManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.userPropertyManager = userPropertyManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
    }

    public Avatar getAvatar(User remoteUser, String avatarUserId) throws AvatarsDisabledException {
        return this.getAvatarImpl(remoteUser, false, avatarUserId);
    }

    private Avatar getAvatarImpl(User remoteUser, boolean skipPermissionCheck, String avatarUserId) {
        User user = this.userManager.getUserObject(avatarUserId);
        if (user != null) {
            Avatar avatar;
            Long customAvatarId = this.configuredAvatarIdFor(user);
            if (customAvatarId != null && (avatar = this.avatarManager.getById(customAvatarId)) != null && (skipPermissionCheck || this.canViewAvatar(remoteUser, avatar))) {
                return avatar;
            }
            Avatar defaultAvatar = this.getDefaultAvatar();
            this.log.debug("Avatar not configured for user '{}', using default id {}", (Object)avatarUserId, (Object)(defaultAvatar != null ? defaultAvatar.getId() : null));
            return defaultAvatar;
        }
        Avatar anonymousAvatar = this.getAnonymousAvatar();
        this.log.debug("User '{}' does not exist, using anonymous avatar id {}", (Object)avatarUserId, (Object)(anonymousAvatar != null ? anonymousAvatar.getId() : null));
        return anonymousAvatar;
    }

    public URI getAvatarURL(User remoteUser, String avatarUserId) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUserId, (Avatar.Size)this.defaultAvatarSize.get());
    }

    public URI getAvatarURL(User remoteUser, String avatarUserId, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUserId, size);
    }

    public URI getAvatarUrlNoPermCheck(String avatarUserId, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, avatarUserId, size);
    }

    public URI getAvatarAbsoluteURL(User remoteUser, String avatarUserId, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUserId, size, true);
    }

    private URI getAvatarURLImpl(User remoteUser, boolean skipPermissionCheck, String avatarUserId, Avatar.Size size) {
        return this.getAvatarURLImpl(remoteUser, skipPermissionCheck, avatarUserId, size, false);
    }

    private URI getAvatarURLImpl(User remoteUser, boolean skipPermissionCheck, String avatarUserId, Avatar.Size size, boolean buildAbsoluteURL) {
        boolean useGravatars = this.isGravatarEnabled();
        UrlStrategy urlStrategy = useGravatars ? new GravatarUrlStrategy() : new JiraUrlStrategy(skipPermissionCheck, buildAbsoluteURL);
        return urlStrategy.get(remoteUser, avatarUserId, size != null ? size : (Avatar.Size)this.defaultAvatarSize.get());
    }

    public boolean hasCustomUserAvatar(User remoteUser, String username) {
        User user = this.userManager.getUserObject(username);
        return user != null && this.configuredAvatarIdFor(user) != null;
    }

    public void setCustomUserAvatar(User remoteUser, String username, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        User user = this.userManager.getUserObject(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        if (!this.canSetCustomUserAvatar(remoteUser, username)) {
            throw new NoPermissionException();
        }
        this.setConfiguredAvatarIdFor(user, avatarId);
    }

    public boolean canSetCustomUserAvatar(User remoteUser, String username) {
        return !this.isGravatarEnabled() && this.avatarManager.hasPermissionToEdit(remoteUser, Avatar.Type.USER, username);
    }

    public URI getProjectAvatarURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    public URI getProjectAvatarAbsoluteURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    private URI getProjectAvatarURLImpl(Project project, Avatar.Size size, String baseUrl) {
        Long avatarId;
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        urlBuilder.addParameter("pid", (Object)project.getId());
        Avatar avatar = project.getAvatar();
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            urlBuilder.addParameter("avatarId", avatarId.toString());
        }
        return urlBuilder.asURI();
    }

    protected Long configuredAvatarIdFor(User user) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        if (userProperties.exists("user.avatar.id")) {
            long avatarId = userProperties.getLong("user.avatar.id");
            this.log.debug("Avatar configured for user '{}' is {}", (Object)user.getName(), (Object)avatarId);
            return avatarId;
        }
        return null;
    }

    public boolean isGravatarEnabled() {
        return this.applicationProperties.getOption("jira.user.avatar.gravatar.enabled");
    }

    protected void setConfiguredAvatarIdFor(User user, Long avatarId) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        userProperties.setLong("user.avatar.id", avatarId.longValue());
        this.log.debug("Set configured avatar id for user '{}' to {}", (Object)user.getName(), (Object)avatarId);
    }

    protected boolean canViewAvatar(User user, Avatar avatar) {
        boolean hasPermission = this.avatarManager.hasPermissionToView(user, avatar.getAvatarType(), avatar.getOwner());
        if (!hasPermission) {
            this.log.debug("User '{}' is not allowed to view avatar {}", (Object)user, (Object)avatar.getId());
        }
        return hasPermission;
    }

    protected Avatar getDefaultAvatar() {
        Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.USER);
        return defaultAvatarId != null ? this.avatarManager.getById(defaultAvatarId) : null;
    }

    protected Avatar getAnonymousAvatar() {
        Long anonAvatarId = this.avatarManager.getAnonymousAvatarId();
        return anonAvatarId != null ? this.avatarManager.getById(anonAvatarId) : null;
    }

    private URI buildUriForAvatar(Avatar avatar, @Nonnull Avatar.Size size, boolean absoluteUrl) {
        Long avatarId;
        String ownerId;
        VelocityRequestContext jiraVelocityRequestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String baseUrl = absoluteUrl ? jiraVelocityRequestContext.getCanonicalBaseUrl() : jiraVelocityRequestContext.getBaseUrl();
        UrlBuilder builder = new UrlBuilder(baseUrl + "/secure/useravatar", this.applicationProperties.getEncoding(), false);
        if (!size.isDefault) {
            builder.addParameter("size", size.param);
        }
        String string = ownerId = avatar != null ? avatar.getOwner() : null;
        if (ownerId != null) {
            builder.addParameter("ownerId", ownerId);
        }
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            builder.addParameter("avatarId", avatarId.toString());
        }
        return builder.asURI();
    }

    private class GravatarUrlStrategy
    implements UrlStrategy {
        private GravatarUrlStrategy() {
        }

        @Override
        public URI get(User remoteUser, String username, @Nonnull Avatar.Size size) {
            User user = AvatarServiceImpl.this.userManager.getUserObject(username);
            if (user != null && user.getEmailAddress() != null) {
                String email = user.getEmailAddress();
                String hash = MD5Util.md5Hex(email);
                URI jiraBaseUrl = URI.create(AvatarServiceImpl.this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
                String gravatarBaseUrl = "https".equalsIgnoreCase(jiraBaseUrl.getScheme()) ? String.format("https://secure.gravatar.com/avatar/%s", hash) : String.format("http://www.gravatar.com/avatar/%s", hash);
                return new UrlBuilder(gravatarBaseUrl).addParameter("d", this.getPublicUrlOfDefaultAvatar(size)).addParameter("s", size.pixels.toString()).asURI();
            }
            return AvatarServiceImpl.this.buildUriForAvatar(AvatarServiceImpl.this.getAnonymousAvatar(), size, true);
        }

        private String getPublicUrlOfDefaultAvatar(Avatar.Size size) {
            if (DEFAULT_AVATAR_PUBLIC_URL.containsKey((Object)size)) {
                return (String)DEFAULT_AVATAR_PUBLIC_URL.get((Object)size);
            }
            return (String)DEFAULT_AVATAR_PUBLIC_URL.get((Object)Avatar.Size.LARGE);
        }
    }

    private class JiraUrlStrategy
    implements UrlStrategy {
        private final boolean skipPermissionCheck;
        private final boolean buildAbsoluteURL;

        public JiraUrlStrategy(boolean skipPermissionCheck, boolean buildAbsoluteURL) {
            this.skipPermissionCheck = skipPermissionCheck;
            this.buildAbsoluteURL = buildAbsoluteURL;
        }

        @Override
        public URI get(User remoteUser, String username, @Nonnull Avatar.Size size) {
            Avatar avatar = AvatarServiceImpl.this.getAvatarImpl(remoteUser, this.skipPermissionCheck, username);
            return AvatarServiceImpl.this.buildUriForAvatar(avatar, size, this.buildAbsoluteURL);
        }
    }

    private static interface UrlStrategy {
        public URI get(User var1, String var2, @Nonnull Avatar.Size var3);
    }
}

