/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.google.common.base.Supplier;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.config.DatasourceInfo;

public class PostgresSchemaConfigCheck
implements StartupCheck {
    private static final Logger log = Logger.getLogger(PostgresSchemaConfigCheck.class);
    private static final String FIELD_TYPE_NAME_POSTGRES72 = "postgres72";
    private static final String FIELD_TYPE_NAME_POSTGRES = "postgres";
    private boolean loggedError = false;
    private final ExternalLinkUtil externalLinkUtil;
    private Supplier<DatasourceInfo> datasourceInfoSupplier;

    public PostgresSchemaConfigCheck(Supplier<DatasourceInfo> datasourceInfoSupplier, ExternalLinkUtil externalLinkUtil) {
        this.datasourceInfoSupplier = datasourceInfoSupplier;
        this.externalLinkUtil = externalLinkUtil;
    }

    @Override
    public String getName() {
        return "Postgres upper case schema name check.";
    }

    @Override
    public boolean isOk() {
        DatasourceInfo dsi = this.getDatasourceInfo();
        if (dsi != null) {
            String schemaName;
            String fieldTypeName = dsi.getFieldTypeName();
            if ((FIELD_TYPE_NAME_POSTGRES.equals(fieldTypeName) || FIELD_TYPE_NAME_POSTGRES72.equals(fieldTypeName)) && !this.isSchemaNameValid(schemaName = dsi.getSchemaName())) {
                log.error((Object)("The schema name '" + schemaName + "' in your " + "dbconfig.xml" + " file contains upper case characters and JIRA only supports lower case schemas in POSTGRES."));
                log.error((Object)"JIRA will work as long as the real schema name in the Postgres database is really lower case. ");
                log.error((Object)("Please refer to the JIRA database documentation at the following URL: " + this.externalLinkUtil.getProperty("external.link.jira.doc.postgres.db.config")));
                this.loggedError = true;
            }
        } else {
            log.error((Object)"Could not read the datasource info!");
            this.loggedError = true;
        }
        return true;
    }

    DatasourceInfo getDatasourceInfo() {
        return (DatasourceInfo)this.datasourceInfoSupplier.get();
    }

    boolean isLoggedError() {
        return this.loggedError;
    }

    public void setLoggedError(boolean loggedError) {
        this.loggedError = loggedError;
    }

    private boolean isSchemaNameValid(String schemaName) {
        if (schemaName == null) {
            return false;
        }
        String lowerCaseSchemaName = schemaName.toLowerCase(Locale.ENGLISH);
        return lowerCaseSchemaName.equals(schemaName);
    }

    @Override
    public String getFaultDescription() {
        return "You have an error in your dbconfig.xml file.\nThe schema-name contains upper case letters and JIRA only supports lower case SCHEMAs in POSTGRES.\nPlease refer to the JIRA database documentation at the following URL: " + this.externalLinkUtil.getProperty("external.link.jira.doc.postgres.db.config");
    }

    @Override
    public String getHTMLFaultDescription() {
        return "<p>You have an error in your dbconfig.xml file. The schema-name=\"PUBLIC\" only works for a field-type-name of \"hsql\". Please refer to the <a href=\"" + this.externalLinkUtil.getProperty("external.link.jira.doc.postgres.db.config") + "\">JIRA database documentation</a>.</p>";
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return this.getName();
    }
}

