/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueVerifier;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.StepTaskProgressSink;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationSuccess;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationTerminated;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowAsynchMigrator;
import com.atlassian.jira.workflow.migration.WorkflowMigrationMapping;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationCompletedEvent;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class WorkflowMigrationHelper<T extends WorkflowScheme> {
    private static final Logger log = Logger.getLogger(WorkflowMigrationHelper.class);
    private final GenericValue project;
    final T targetScheme;
    final WorkflowManager workflowManager;
    private final SchemeManager schemeManager;
    private final List<GenericValue> typesNeedingMigration;
    private final Map<GenericValue, Collection<GenericValue>> statusesNeedingMigration;
    private final WorkflowMigrationMapping workflowMigrationMapping;
    protected final String projectName;
    final Long projectId;
    private final OfBizDelegator delegator;
    private final User user;
    private final ConstantsManager constantsManager;
    private final I18nHelper i18nHelper;
    final Long schemeId;
    private final String schemeName;
    private final TaskManager taskManager;
    private final IssueIndexManager issueIndexManager;
    final WorkflowSchemeManager workflowSchemeManager;
    private final EventPublisher eventPublisher;

    WorkflowMigrationHelper(GenericValue project, T targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher) throws WorkflowException, GenericEntityException {
        this.project = project;
        this.targetScheme = targetScheme;
        this.workflowManager = workflowManager;
        this.delegator = delegator;
        this.schemeManager = schemeManager;
        this.i18nHelper = i18nHelper;
        this.user = user;
        this.taskManager = taskManager;
        this.issueIndexManager = issueIndexManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.eventPublisher = eventPublisher;
        this.workflowMigrationMapping = new WorkflowMigrationMapping();
        this.constantsManager = constantsManager;
        this.typesNeedingMigration = new ArrayList<GenericValue>();
        this.statusesNeedingMigration = new HashMap<GenericValue, Collection<GenericValue>>();
        this.projectName = project.getString("name");
        this.projectId = project.getLong("id");
        if (targetScheme == null) {
            this.schemeId = null;
            this.schemeName = i18nHelper.getText("admin.common.words.default");
        } else {
            this.schemeId = targetScheme.getId();
            this.schemeName = targetScheme.getName();
        }
        this.calculateInputRequired();
    }

    private void calculateInputRequired() throws WorkflowException, GenericEntityException {
        List issueTypes = this.getConstantsManager().getAllIssueTypes();
        for (GenericValue issueType : issueTypes) {
            String issueTypeId = issueType.getString("id");
            JiraWorkflow existingWorkflow = this.getExistingWorkflow(issueTypeId);
            JiraWorkflow targetWorkflow = this.getTargetWorkflow(issueTypeId);
            boolean needMigration = false;
            if (existingWorkflow.equals(targetWorkflow)) {
                Collection<Long> issueIdsOnWrongWorkflow = this.getIssueIdsOnWrongWorkflow(issueTypeId, existingWorkflow.getName());
                if (issueIdsOnWrongWorkflow != null && !issueIdsOnWrongWorkflow.isEmpty()) {
                    needMigration = true;
                    this.addIssueIdsOnWrongWorkflow(issueIdsOnWrongWorkflow);
                }
            } else {
                needMigration = true;
            }
            if (!needMigration) continue;
            HashSet<GenericValue> existingStatuses = new HashSet<GenericValue>(existingWorkflow.getLinkedStatuses());
            Collection<GenericValue> actualExistingStatuses = this.getUniqueStatusesForIssueType(issueTypeId);
            existingStatuses.addAll(actualExistingStatuses);
            List targetStatuses = targetWorkflow.getLinkedStatuses();
            existingStatuses.removeAll(targetStatuses);
            if (existingStatuses.size() > 0) {
                this.typesNeedingMigration.add(issueType);
                this.statusesNeedingMigration.put(issueType, existingStatuses);
            }
            HashSet<GenericValue> intersection = new HashSet<GenericValue>(existingWorkflow.getLinkedStatuses());
            intersection.addAll(actualExistingStatuses);
            intersection.retainAll(targetStatuses);
            for (GenericValue status : intersection) {
                this.addMapping(issueType, status, status);
            }
        }
    }

    private Collection<GenericValue> getUniqueStatusesForIssueType(String issueTypeId) throws GenericEntityException {
        if (issueTypeId == null) {
            throw new NullPointerException("Issue Type should not be null.");
        }
        return this.getUniqueStatuses((EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)this.projectId, (Object)"type", (Object)issueTypeId), EntityOperator.AND));
    }

    private void addIssueIdsOnWrongWorkflow(Collection<Long> issueIdsOnWrongWorkflow) {
        if (issueIdsOnWrongWorkflow != null) {
            this.workflowMigrationMapping.addIssueIdsOnWorongWorkflow(issueIdsOnWrongWorkflow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> getIssueIdsOnWrongWorkflow(String issueTypeId, String expectedWorkflowName) throws GenericEntityException {
        if (issueTypeId == null) {
            throw new IllegalArgumentException("Issue Type id should not be null.");
        }
        ArrayList<Long> issueIds = new ArrayList<Long>();
        OfBizListIterator listIterator = null;
        try {
            EntityFieldMap projectIssueTypeClause = new EntityFieldMap((Map)ImmutableMap.of((Object)"issueProject", (Object)this.projectId, (Object)"issueType", (Object)issueTypeId), EntityOperator.AND);
            EntityExpr workflowClause = new EntityExpr("workflowName", EntityOperator.NOT_EQUAL, (Object)expectedWorkflowName);
            EntityExpr condition = new EntityExpr((EntityCondition)projectIssueTypeClause, EntityOperator.AND, (EntityCondition)workflowClause);
            listIterator = this.getDelegator().findListIteratorByCondition("IssueWorkflowEntryView", (EntityCondition)condition, null, Arrays.asList("issueId"), null, null);
            GenericValue issueIdGV = listIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("issueId"));
                issueIdGV = listIterator.next();
            }
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        return Collections.unmodifiableList(issueIds);
    }

    private JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(this.projectId, issueTypeId);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with project '" + this.projectName + "', issuetype " + issueTypeId);
        }
        return workflow;
    }

    private JiraWorkflow getTargetWorkflow(String issueTypeId) throws WorkflowException {
        String workflowName = this.targetScheme.getActualWorkflow(issueTypeId);
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with project '" + this.projectName + "', issuetype " + issueTypeId);
        }
        return workflow;
    }

    public List<GenericValue> getTypesNeedingMigration() {
        return this.typesNeedingMigration;
    }

    public Collection<GenericValue> getStatusesNeedingMigration(GenericValue issueType) {
        return this.statusesNeedingMigration.get(issueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkflowMigrationResult migrate(TaskProgressSink sink) throws GenericEntityException, WorkflowException {
        WorkflowMigrationResult workflowMigrationResult;
        Collection<Long> issueIds;
        UtilTimerStack.push((String)"EnterpriseWorkflowMigrationHelper.migrate");
        log.info((Object)("Started workflow migration for project '" + this.projectName + "'."));
        if (sink == null) {
            sink = TaskProgressSink.NULL_SINK;
        }
        StatefulTaskProgressSink migrationSink = new StatefulTaskProgressSink(0L, 100L, sink);
        String currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.verification");
        log.info((Object)("Verifying issues can be moved to another workflow for project '" + this.projectName + "'."));
        migrationSink.makeProgress(0L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.find.affected.issues", this.projectName));
        UtilTimerStack.push((String)"Verifying Issues can be moved to another workflow");
        IssueVerifier issueVerifier = new IssueVerifier();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            issueIds = this.getIssueIds(this.projectId);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while validating issues for workflow migration on project '" + this.projectName + "'."), (Throwable)e);
            errorCollection.addErrorMessage("Error occurred while retrieving issues for verifying for workflow migration: " + e.getMessage());
            UtilTimerStack.pop((String)"Verifying Issues can be moved to another workflow");
            WorkflowMigrationTerminated workflowMigrationTerminated = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
            UtilTimerStack.pop((String)"EnterpriseWorkflowMigrationHelper.migrate");
            return workflowMigrationTerminated;
        }
        migrationSink.makeProgressIncrement(5L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.found.affected.issues", this.projectName));
        try {
            int numberOfIssues = issueIds.size();
            StepTaskProgressSink issueSink = migrationSink.createStepSinkView(6L, 40L, numberOfIssues);
            int issueCounter = 1;
            for (Long issueId : issueIds) {
                issueSink.makeProgress(issueCounter, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.verify.issue", String.valueOf(issueCounter), String.valueOf(numberOfIssues), this.projectName));
                GenericValue issueGV = this.retrieveIssue(issueId);
                if (issueGV != null) {
                    ErrorCollection possibleErrors = issueVerifier.verifyForMigration(issueGV, this.typesNeedingMigration, this.workflowMigrationMapping, false);
                    errorCollection.addErrorCollection(possibleErrors);
                } else {
                    log.debug((Object)("Issue with id '" + issueId + "' not found."));
                }
                ++issueCounter;
            }
            if (errorCollection != null && errorCollection.hasAnyErrors()) {
                log.info((Object)("Enterprise workflow migration failed with invalid issues for project '" + this.projectName + "'."));
                WorkflowMigrationTerminated workflowMigrationTerminated = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
                return workflowMigrationTerminated;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while verifying issues for workflow migration on project '" + this.projectName + "'."), (Throwable)e);
            errorCollection.addErrorMessage(this.getI18nHelper().getText("admin.errors.workflows.error.occurred.verifying.issues", e.getMessage()));
            WorkflowMigrationTerminated workflowMigrationTerminated = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
            return workflowMigrationTerminated;
        }
        finally {
            UtilTimerStack.pop((String)"Verifying Issues can be moved to another workflow");
        }
        currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.migration");
        migrationSink.makeProgress(47L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.find.affected.issues", this.projectName));
        UtilTimerStack.push((String)"Refinding issues for new workflow");
        try {
            issueIds = this.getIssueIds(this.projectId);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while retrieving issues for workflow migration of project '" + this.projectName + "'."), (Throwable)e);
            errorCollection.addErrorMessage("Error occurred while retrieving issues for workflow migration. " + e.getMessage());
            workflowMigrationResult = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
            UtilTimerStack.pop((String)"EnterpriseWorkflowMigrationHelper.migrate");
            return workflowMigrationResult;
        }
        finally {
            UtilTimerStack.pop((String)"Refinding issues for new workflow");
        }
        migrationSink.makeProgressIncrement(5L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.found.affected.issues", this.projectName));
        WorkflowMigrationResult result = this.migrateIssues(issueIds, migrationSink);
        currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.association");
        log.info((Object)("Assigning workflow scheme to project '" + this.projectName + "'."));
        migrationSink.makeProgress(94L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.assign.workflow", this.getTargetSchemeName(), this.projectName));
        if (result.getResult() == 0) {
            this.complete(this.schemeManager, this.project, this.targetScheme, migrationSink);
        }
        log.info((Object)("Workflow migration complete for project '" + this.projectName + "'."));
        migrationSink.makeProgress(100L, null, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.complete"));
        workflowMigrationResult = result;
        return workflowMigrationResult;
        finally {
            UtilTimerStack.pop((String)"EnterpriseWorkflowMigrationHelper.migrate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private WorkflowMigrationResult migrateIssues(Collection issueIds, StatefulTaskProgressSink percentageSink) throws GenericEntityException {
        UtilTimerStack.push((String)"Moving issues to new workflow");
        failedIssues = new HashMap<Long, String>();
        WorkflowMigrationHelper.log.info((Object)("Migrating issues in project '" + this.projectName + "' to new workflow."));
        try {
            numberOfIssues = issueIds.size();
            issueCounter = 1L;
            issueSink = percentageSink.createStepSinkView(53L, 40L, numberOfIssues);
            currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.migration");
            iterator = issueIds.iterator();
            while (iterator.hasNext()) {
                block15: {
                    issueSink.makeProgress(issueCounter, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.migrate.issue", String.valueOf(issueCounter), String.valueOf(numberOfIssues), this.projectName));
                    issueId = (Long)iterator.next();
                    issueGV = this.retrieveIssue(issueId);
                    if (issueGV == null) break block15;
                    try {
                        currentIssueType = this.getConstantsManager().getIssueType(issueGV.getString("type"));
                        originalWorkflow = this.workflowManager.getWorkflow(issueGV);
                        originalStatus = this.getConstantsManager().getStatus(issueGV.getString("status"));
                        originalWfIdString = issueGV.getLong("workflowId").toString();
                        targetStatus = this.typesNeedingMigration.contains(currentIssueType) != false ? this.workflowMigrationMapping.getTargetStatus(issueGV) : this.getConstantsManager().getStatus(issueGV.getString("status"));
                        issueTypeId = issueGV.getString("type");
                        targetWorkflow = this.getTargetWorkflow(issueTypeId);
                        isIssueOnWrongWorkflow = this.workflowMigrationMapping.isIssueOnWrongWorkflow(issueGV.getLong("id"));
                        if (!isIssueOnWrongWorkflow && targetWorkflow.equals(this.getExistingWorkflow(issueTypeId))) ** GOTO lbl-1000
                        txn = Txn.begin();
                        try {
                            this.issueIndexManager.hold();
                            needsIndex = this.workflowManager.migrateIssueToWorkflowNoReindex(issueGV, targetWorkflow, targetStatus);
                            this.createChangeLog(issueGV, originalWfIdString, originalStatus, originalWorkflow, targetWorkflow, targetStatus);
                            txn.commit();
                            if (needsIndex) {
                                this.reindexIssue(issueGV);
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception e) {
                            txn.rollback();
                            throw e;
                        }
                        finally {
                            this.issueIndexManager.release();
                        }
                    }
                    catch (Exception e) {
                        WorkflowMigrationHelper.log.error((Object)("Error occurred while migrating issue to a new workflow for project '" + this.projectName + "'."), (Throwable)e);
                        failedIssues.put(issueId, issueGV.getString("key"));
                        if (failedIssues.size() >= 10) {
                            WorkflowMigrationHelper.log.info((Object)("Enterprise workflow migration cancelled due to number of errors during issues migration for project '" + this.projectName + "'."));
                            var13_13 = new WorkflowMigrationTerminated(failedIssues);
                            UtilTimerStack.pop((String)"Moving issues to new workflow");
                            return var13_13;
                        }
                        ** break block16
                    }
                }
                WorkflowMigrationHelper.log.debug((Object)("Issue with id '" + issueId + "' not found."));
lbl-1000:
                // 4 sources

                {
                    ++issueCounter;
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)"Moving issues to new workflow");
        }
        return new WorkflowMigrationSuccess(failedIssues);
    }

    private void reindexIssue(GenericValue issueGV) {
        String issueKey = issueGV.getString("key");
        try {
            UtilTimerStack.push((String)("Reindexing issue: " + issueKey));
            ComponentAccessor.getIssueIndexManager().reIndex(issueGV);
            UtilTimerStack.pop((String)("Reindexing issue: " + issueKey));
        }
        catch (IndexException e) {
            log.error((Object)("Error occurred while reindexing issue: " + issueKey), (Throwable)e);
        }
    }

    private void createChangeLog(GenericValue issue, String originalWfIdString, GenericValue originalStatus, JiraWorkflow originalWorkflow, JiraWorkflow targetWorkflow, GenericValue targetStatus) {
        String newwfIdString = issue.getLong("workflowId").toString();
        ArrayList<ChangeItemBean> changeItems = new ArrayList<ChangeItemBean>();
        boolean createChangeLog = false;
        if (!originalWfIdString.equals(newwfIdString)) {
            changeItems.add(new ChangeItemBean("jira", "Workflow", originalWfIdString, originalWorkflow.getName(), newwfIdString, targetWorkflow.getName()));
            createChangeLog = true;
        }
        if (!originalStatus.getString("id").equals(targetStatus.getString("id"))) {
            changeItems.add(new ChangeItemBean("jira", "status", originalStatus.getString("id"), originalStatus.getString("name"), targetStatus.getString("id"), targetStatus.getString("name")));
            createChangeLog = true;
        }
        try {
            if (createChangeLog) {
                ChangeLogUtils.createChangeGroup(this.getUser(), issue, issue, changeItems, true);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred creating change log: " + e), (Throwable)e);
        }
    }

    public void addMapping(GenericValue issueType, GenericValue oldStatus, GenericValue newStatus) {
        this.workflowMigrationMapping.addMapping(issueType, oldStatus, newStatus);
    }

    public void associateProjectAndWorkflowScheme() throws GenericEntityException {
        this.complete(this.schemeManager, this.project, this.targetScheme, null);
    }

    private void complete(SchemeManager schemeManager, GenericValue project, T workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        this.completeActually(schemeManager, project, workflowScheme, migrationSink);
        this.eventPublisher.publish((Object)new WorkflowSchemeMigrationCompletedEvent((WorkflowScheme)this.targetScheme));
    }

    abstract void completeActually(SchemeManager var1, GenericValue var2, T var3, StatefulTaskProgressSink var4) throws GenericEntityException;

    public Logger getLogger() {
        return log;
    }

    private String getTargetSchemeName() {
        if (this.targetScheme == null) {
            return this.getI18nHelper().getText("admin.common.words.default");
        }
        return this.targetScheme.getName();
    }

    private OfBizDelegator getDelegator() {
        return this.delegator;
    }

    private ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    User getUser() {
        return this.user;
    }

    I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> getIssueIds(Long projectId) throws GenericEntityException {
        this.getLogger().debug((Object)"Returning all issues associated with project.");
        OfBizListIterator issueIterator = null;
        ArrayList<Long> issueIds = new ArrayList<Long>();
        try {
            EntityFieldMap cond = new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND);
            issueIterator = this.delegator.findListIteratorByCondition("Issue", (EntityCondition)cond, null, Arrays.asList("id"), null, null);
            GenericValue issueIdGV = issueIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = issueIterator.next();
            }
        }
        finally {
            if (issueIterator != null) {
                issueIterator.close();
            }
        }
        return issueIds;
    }

    private GenericValue retrieveIssue(Long issueId) throws GenericEntityException {
        return this.delegator.findById("Issue", issueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<GenericValue> getUniqueStatuses(EntityCondition condition) throws GenericEntityException {
        ArrayList<GenericValue> foundStatuses = new ArrayList<GenericValue>();
        OfBizListIterator listIterator = null;
        try {
            EntityFindOptions findOptions = new EntityFindOptions();
            findOptions.setDistinct(true);
            listIterator = this.getDelegator().findListIteratorByCondition("Issue", condition, null, Arrays.asList("status"), null, findOptions);
            GenericValue statusIdGV = listIterator.next();
            while (statusIdGV != null) {
                GenericValue statusGV = this.constantsManager.getStatus(statusIdGV.getString("status"));
                if (statusGV != null) {
                    foundStatuses.add(statusGV);
                } else {
                    this.getLogger().debug((Object)("Found issue with status id '" + statusIdGV.getString("status") + "'. The status for this id does not exist."));
                }
                statusIdGV = listIterator.next();
            }
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        return foundStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHaveIssuesToMigrate() throws GenericEntityException {
        OfBizListIterator issueIterator = null;
        try {
            issueIterator = this.delegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)this.projectId), EntityOperator.AND));
            boolean bl = issueIterator.next() != null;
            return bl;
        }
        finally {
            if (issueIterator != null) {
                issueIterator.close();
            }
        }
    }

    public boolean doQuickMigrate() throws GenericEntityException {
        if (this.isHaveIssuesToMigrate()) {
            return false;
        }
        this.complete(this.schemeManager, this.project, this.targetScheme, null);
        return true;
    }

    public TaskDescriptor<WorkflowMigrationResult> migrateAsync() throws RejectedExecutionException {
        String taskDesc = this.i18nHelper.getText("admin.selectworkflows.task.desc", this.projectName, this.schemeName);
        EnterpriseWorkflowTaskContext taskContext = this.createEnterpriseWorkflowTaskContext();
        return this.taskManager.submitTask(new WorkflowAsynchMigrator(this), taskDesc, taskContext);
    }

    abstract EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext();
}

