/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.util.dbc.Assertions;

public class EnterpriseWorkflowTaskContext
implements TaskContext {
    private final Long projectId;
    private final Long schemeId;
    private final boolean draftMigration;

    public EnterpriseWorkflowTaskContext(Long projectId, Long schemeId, boolean draftMigration) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        this.schemeId = schemeId;
        this.projectId = projectId;
        this.draftMigration = draftMigration;
    }

    @Override
    public String buildProgressURL(Long taskId) {
        String url = "/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=" + this.getProjectId() + "&taskId=" + taskId + "&draftMigration=" + this.isDraftMigration();
        if (this.getSchemeId() != null) {
            url = url + "&schemeId=" + this.getSchemeId();
        }
        return url;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public boolean isDraftMigration() {
        return this.draftMigration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseWorkflowTaskContext that = (EnterpriseWorkflowTaskContext)o;
        return this.projectId.equals(that.projectId);
    }

    public int hashCode() {
        return this.projectId.hashCode();
    }
}

