/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowMigrationHelper;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DraftWorkflowMigrationHelper
extends WorkflowMigrationHelper<DraftWorkflowScheme> {
    DraftWorkflowMigrationHelper(GenericValue project, DraftWorkflowScheme targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher) throws WorkflowException, GenericEntityException {
        super(project, targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager, eventPublisher);
    }

    @Override
    void completeActually(SchemeManager schemeManager, GenericValue project, DraftWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        if (migrationSink != null) {
            migrationSink.makeProgress(99L, null, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.deleting.draft", this.projectName));
        }
        this.replaceSchemeWithDraft();
    }

    private void replaceSchemeWithDraft() throws GenericEntityException {
        AssignableWorkflowScheme parentScheme = this.workflowSchemeManager.getParentForDraft(((DraftWorkflowScheme)this.targetScheme).getId().longValue());
        parentScheme = this.copyDraftMappingsToParent(parentScheme);
        this.workflowSchemeManager.updateWorkflowScheme(parentScheme);
        this.workflowSchemeManager.deleteWorkflowScheme(this.targetScheme);
        ComponentAccessor.getWorkflowSchemeManager().clearWorkflowCache();
    }

    private AssignableWorkflowScheme copyDraftMappingsToParent(AssignableWorkflowScheme parentScheme) {
        return ((AssignableWorkflowScheme.Builder)parentScheme.builder().setMappings(((DraftWorkflowScheme)this.targetScheme).getMappings())).build();
    }

    @Override
    EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext() {
        return new EnterpriseWorkflowTaskContext(this.projectId, this.schemeId, true);
    }
}

