/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCopiedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCreatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeDeletedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DefaultWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowSchemeImpl;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeImpl;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWorkflowSchemeManager
extends AbstractSchemeManager
implements WorkflowSchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultWorkflowSchemeManager.class);
    private static final String ALL_ISSUE_TYPES = "0";
    private static final String SCHEME_ENTITY_NAME = "WorkflowScheme";
    private static final String WORKFLOW_ENTITY_NAME = "WorkflowSchemeEntity";
    private static final String SCHEME_DESC = "Workflow";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.workflows.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.workflows.default.desc";
    private static final String COLUMN_ISSUETYPE = "issuetype";
    private static final String COLUMN_WORKFLOW = "workflow";
    private final AssignableWorkflowScheme defaultScheme;
    private final Map<Long, Map<String, GenericValue>> cache = new ConcurrentHashMap<Long, Map<String, GenericValue>>();
    private final ActiveWorkflowCache activeWorkflowCache = new ActiveWorkflowCache();
    private final WorkflowManager workflowManager;
    private final ConstantsManager constantsManager;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final DraftWorkflowSchemeStore draftWorkflowSchemeStore;
    private final UserManager userManager;

    public DefaultWorkflowSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, WorkflowManager workflowManager, ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, AssociationManager associationManager, GroupManager groupManager, DraftWorkflowSchemeStore draftWorkflowSchemeStore, JiraAuthenticationContext context, UserManager userManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, ofBizDelegator, groupManager);
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.draftWorkflowSchemeStore = draftWorkflowSchemeStore;
        this.userManager = userManager;
        this.defaultScheme = new DefaultWorkflowScheme(context);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearWorkflowCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return WORKFLOW_ENTITY_NAME;
    }

    public void clearWorkflowCache() {
        this.activeWorkflowCache.clear();
        this.clearCache();
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    public GenericValue getWorkflowScheme(GenericValue project) throws GenericEntityException {
        return EntityUtil.getOnly(this.getSchemes(project));
    }

    private Map<String, String> toWorkflowMap(Iterable<GenericValue> related) {
        HashMap mapping = Maps.newHashMap();
        for (GenericValue value : related) {
            String issuetype = value.getString(COLUMN_ISSUETYPE);
            String workflow = value.getString(COLUMN_WORKFLOW);
            if (issuetype == null) continue;
            if (ALL_ISSUE_TYPES.equals(issuetype)) {
                mapping.put(null, workflow);
                continue;
            }
            mapping.put(issuetype, workflow);
        }
        return mapping;
    }

    public boolean hasDraft(@Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        return !scheme.isDefault() && scheme.getId() != null && this.draftWorkflowSchemeStore.hasDraftForParent(scheme.getId());
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        return this.createSchemeEntity(scheme.getLong("id"), schemeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericValue createSchemeEntity(long schemeId, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof String)) {
            throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
        }
        try {
            GenericValue result;
            GenericValue genericValue = result = EntityUtils.createValue(this.getEntityName(), (Map<String, Object>)FieldMap.build((String)"scheme", (Object)schemeId, (String)COLUMN_WORKFLOW, (Object)schemeEntity.getType(), (String)COLUMN_ISSUETYPE, (Object)schemeEntity.getEntityTypeId().toString()));
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing workflow scheme entity cache, had " + this.cache.size() + " entries"));
        }
        this.cache.clear();
    }

    public List<GenericValue> getEntities(GenericValue scheme, String issuetype) throws GenericEntityException {
        Map<String, GenericValue> genericValueMap = this.getAndCacheSchemeMap(scheme);
        GenericValue value = genericValueMap.get(issuetype);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    public Map<String, String> getWorkflowMap(Project project) {
        GenericValue schemeForProject = this.getSchemeForProject(project);
        return this.getWorkflowMap(schemeForProject);
    }

    @VisibleForTesting
    Map<String, String> getWorkflowMap(GenericValue schemeForProject) {
        if (schemeForProject == null) {
            return MapBuilder.build(null, (Object)"jira");
        }
        Map<String, GenericValue> schemeMap = this.getAndCacheSchemeMap(schemeForProject);
        return this.toWorkflowMap(schemeMap.values());
    }

    public String getWorkflowName(Project project, String issueType) {
        return this.getWorkflowName(this.getSchemeForProject(project), issueType);
    }

    public String getWorkflowName(GenericValue scheme, String issueType) {
        if (scheme != null) {
            Map<String, GenericValue> map = this.getAndCacheSchemeMap(scheme);
            GenericValue value = map.get(issueType);
            if (value == null) {
                value = map.get(ALL_ISSUE_TYPES);
            }
            if (value != null) {
                return value.getString(COLUMN_WORKFLOW);
            }
        }
        return "jira";
    }

    public boolean isUsingDefaultScheme(Project project) {
        return this.getSchemeForProject(project) == null;
    }

    @VisibleForTesting
    GenericValue getSchemeForProject(Project project) {
        return this.getSchemeForProject(project.getGenericValue());
    }

    @VisibleForTesting
    GenericValue getSchemeForProject(GenericValue project) {
        try {
            return EntityUtil.getOnly(this.getSchemes(project));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static Long getCacheKeyForScheme(GenericValue scheme) {
        return scheme.getLong("id");
    }

    private Map<String, GenericValue> getAndCacheSchemeMap(GenericValue scheme) {
        if (scheme == null) {
            return Collections.emptyMap();
        }
        Long cacheKeyForScheme = DefaultWorkflowSchemeManager.getCacheKeyForScheme(scheme);
        Map<String, GenericValue> cachedEntry = this.cache.get(cacheKeyForScheme);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        Map<String, GenericValue> schemeMap = this.getSchemeMapFromDatabase(scheme);
        this.cache.put(cacheKeyForScheme, Collections.unmodifiableMap(schemeMap));
        return schemeMap;
    }

    private Map<String, GenericValue> getSchemeMapFromDatabase(GenericValue scheme) {
        List valueList;
        try {
            valueList = scheme.getRelated("Child" + scheme.getEntityName() + "Entity");
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        HashMap<String, GenericValue> schemeMap = new HashMap<String, GenericValue>();
        for (GenericValue value : valueList) {
            String issueType = value.getString(COLUMN_ISSUETYPE);
            if (issueType == null) continue;
            schemeMap.put(issueType, value);
        }
        return schemeMap;
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString(COLUMN_WORKFLOW), (Object)entity.getString(COLUMN_ISSUETYPE));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId, String parameter) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity) {
        return false;
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity, User user, boolean issueCreation) {
        return false;
    }

    public GenericValue getDefaultEntity(GenericValue scheme) throws GenericEntityException {
        return EntityUtil.getOnly(this.getEntities(scheme, ALL_ISSUE_TYPES));
    }

    public AssignableWorkflowScheme getDefaultWorkflowScheme() {
        return this.defaultScheme;
    }

    public List<GenericValue> getNonDefaultEntities(GenericValue scheme) throws GenericEntityException {
        List<GenericValue> entities = this.getEntities(scheme);
        Iterator<GenericValue> iterator = entities.iterator();
        while (iterator.hasNext()) {
            GenericValue genericValue = iterator.next();
            if (!ALL_ISSUE_TYPES.equals(genericValue.getString(COLUMN_ISSUETYPE))) continue;
            iterator.remove();
            break;
        }
        return entities;
    }

    public Collection<String> getActiveWorkflowNames() throws GenericEntityException, WorkflowException {
        return this.activeWorkflowCache.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowToScheme(GenericValue scheme, String workflowName, String issueTypeId) throws GenericEntityException {
        try {
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            if (this.getEntities(scheme, issueTypeId).isEmpty()) {
                this.createSchemeEntity(scheme, schemeEntity);
            }
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    @Nonnull
    public DraftWorkflowScheme createDraftOf(ApplicationUser creator, @Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        Assertions.not((String)"workflowScheme.default", (boolean)workflowScheme.isDefault());
        Assertions.notNull((String)"workflowScheme.id", (Object)workflowScheme.getId());
        Assertions.not((String)"scheme already has draft.", (boolean)this.hasDraft(workflowScheme));
        DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder builder = this.draftWorkflowSchemeStore.builder(workflowScheme.getId());
        builder.setName(workflowScheme.getName());
        builder.setDescription(workflowScheme.getDescription());
        builder.setMappings(workflowScheme.getMappings());
        builder.setLastModifiedUser(creator != null ? creator.getKey() : null);
        DraftWorkflowSchemeStore.DraftWorkflowSchemeState state = this.draftWorkflowSchemeStore.create(builder.build());
        return this.toWorkflowScheme(state);
    }

    public void updateSchemesForRenamedWorkflow(String oldWorkflowName, String newWorkflowName) {
        if (StringUtils.isBlank((String)oldWorkflowName)) {
            throw new IllegalArgumentException("oldWorkflowName must not be null or empty string");
        }
        if (StringUtils.isBlank((String)newWorkflowName)) {
            throw new IllegalArgumentException("newWorkflowName must not be null or empty string");
        }
        this.ofBizDelegator.bulkUpdateByAnd(this.getEntityName(), (Map)ImmutableMap.of((Object)COLUMN_WORKFLOW, (Object)newWorkflowName), (Map)ImmutableMap.of((Object)COLUMN_WORKFLOW, (Object)oldWorkflowName));
        this.draftWorkflowSchemeStore.renameWorkflow(oldWorkflowName, newWorkflowName);
        this.clearWorkflowCache();
    }

    public Collection<GenericValue> getSchemesForWorkflow(JiraWorkflow workflow) {
        LinkedList<GenericValue> schemes = new LinkedList<GenericValue>();
        HashSet<Long> schemeIds = new HashSet<Long>();
        List schemeEntities = this.ofBizDelegator.findByAnd(this.getEntityName(), MapBuilder.build((Object)COLUMN_WORKFLOW, (Object)workflow.getName()));
        for (GenericValue schemeEntity : schemeEntities) {
            Long schemeId = schemeEntity.getLong("scheme");
            if (schemeIds.contains(schemeId)) continue;
            schemes.add(this.getScheme(schemeId));
            schemeIds.add(schemeId);
        }
        return schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        try {
            super.deleteEntity(id);
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scheme createSchemeObject(String name, String description) {
        try {
            Scheme scheme = super.createSchemeObject(name, description);
            if (scheme != null) {
                this.eventPublisher.publish((Object)new WorkflowSchemeCreatedEvent(scheme));
            }
            Scheme scheme2 = scheme;
            return scheme2;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public Scheme copyScheme(Scheme scheme) {
        Scheme result = super.copyScheme(scheme);
        if (result != null) {
            this.eventPublisher.publish((Object)new WorkflowSchemeCopiedEvent(scheme, result));
        }
        return result;
    }

    @Override
    public void updateScheme(Scheme scheme) throws DataAccessException {
        super.updateScheme(scheme);
        this.eventPublisher.publish((Object)new WorkflowSchemeUpdatedEvent(scheme));
    }

    @Override
    public void deleteScheme(Long id) {
        if (id == null) {
            return;
        }
        try {
            super.deleteScheme(id);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.draftWorkflowSchemeStore.deleteByParentId(id);
        this.eventPublisher.publish((Object)new WorkflowSchemeDeletedEvent(id));
    }

    @Override
    public void addSchemeToProject(GenericValue project, GenericValue scheme) throws GenericEntityException {
        super.addSchemeToProject(project, scheme);
        Long projectId = project == null ? null : project.getLong("id");
        Long schemeId = scheme == null ? null : scheme.getLong("id");
        this.eventPublisher.publish((Object)new WorkflowSchemeAddedToProjectEvent(projectId, schemeId));
    }

    @Override
    public void addSchemeToProject(Project project, Scheme scheme) throws DataAccessException {
        super.addSchemeToProject(project, scheme);
        Long projectId = project == null ? null : project.getId();
        Long schemeId = scheme == null ? null : scheme.getId();
        this.eventPublisher.publish((Object)new WorkflowSchemeAddedToProjectEvent(projectId, schemeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    protected List<GenericValue> getAllIssueTypes() {
        return this.constantsManager.getAllIssueTypes();
    }

    protected JiraWorkflow getWorkflowFromScheme(GenericValue workflowScheme, String issueTypeId) {
        return this.workflowManager.getWorkflowFromScheme(workflowScheme, issueTypeId);
    }

    @Nullable
    public AssignableWorkflowScheme getWorkflowSchemeObj(long id) {
        return this.toWorkflowScheme(this.getScheme(id));
    }

    public DraftWorkflowScheme getDraftForParent(@Nonnull AssignableWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (scheme.isDefault() || scheme.getId() == null) {
            return null;
        }
        DraftWorkflowSchemeStore.DraftWorkflowSchemeState draftScheme = this.draftWorkflowSchemeStore.getDraftForParent(scheme.getId());
        return this.toWorkflowScheme(draftScheme);
    }

    public DraftWorkflowScheme getDraft(long id) {
        DraftWorkflowSchemeStore.DraftWorkflowSchemeState draftScheme = this.draftWorkflowSchemeStore.get(id);
        return this.toWorkflowScheme(draftScheme);
    }

    public AssignableWorkflowScheme getParentForDraft(long draftSchemeId) {
        long parentId = this.draftWorkflowSchemeStore.getParentId(draftSchemeId);
        return this.getWorkflowSchemeObj(parentId);
    }

    public boolean isActive(@Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (scheme.isDraft()) {
            return false;
        }
        if (scheme.isDefault()) {
            List projectObjects = this.projectManager.getProjectObjects();
            for (Project projectObject : projectObjects) {
                if (!this.isUsingDefaultScheme(projectObject)) continue;
                return true;
            }
            return false;
        }
        if (scheme.getId() == null) {
            return false;
        }
        try {
            GenericValue genericValue = this.getScheme(scheme.getId());
            if (genericValue != null) {
                List<GenericValue> projects = this.getProjects(genericValue);
                return !projects.isEmpty();
            }
            return false;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public boolean deleteWorkflowScheme(@Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.not((String)"scheme.default", (boolean)scheme.isDefault());
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        if (scheme.isDraft()) {
            return this.draftWorkflowSchemeStore.delete(scheme.getId());
        }
        Assertions.not((String)"Cannot delete active scheme.", (boolean)this.isActive(scheme));
        this.deleteScheme(scheme.getId());
        return true;
    }

    public DraftWorkflowScheme updateDraftWorkflowScheme(ApplicationUser user, @Nonnull DraftWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        Assertions.notNull((String)"scheme.id", (Object)scheme.getId());
        DraftWorkflowSchemeStore.DraftWorkflowSchemeState savedState = this.draftWorkflowSchemeStore.get(scheme.getId());
        Assertions.notNull((String)String.format("scheme with id %d does not exist.", scheme.getId()), (Object)savedState);
        DraftWorkflowSchemeStore.DraftWorkflowSchemeState.Builder builder = savedState.builder();
        builder.setName(scheme.getName()).setDescription(scheme.getDescription());
        builder.setMappings(scheme.getMappings());
        builder.setLastModifiedUser(user == null ? null : user.getKey());
        return this.toWorkflowScheme(this.draftWorkflowSchemeStore.update(builder.build()));
    }

    public AssignableWorkflowScheme updateWorkflowScheme(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"scheme", (Object)workflowScheme);
        Scheme scheme = this.getSchemeObject(workflowScheme.getId());
        Collection entities = scheme.getEntities();
        for (SchemeEntity schemeEntity : entities) {
            this.deleteEntity(schemeEntity.getId());
        }
        scheme = new Scheme(workflowScheme.getId(), this.getSchemeEntityName(), workflowScheme.getName(), workflowScheme.getDescription(), Collections.emptyList());
        this.updateScheme(scheme);
        for (Map.Entry entry : workflowScheme.getMappings().entrySet()) {
            String issueTypeId = (String)entry.getKey();
            if (issueTypeId == null) {
                issueTypeId = ALL_ISSUE_TYPES;
            }
            String workflowName = (String)entry.getValue();
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            try {
                this.createSchemeEntity(workflowScheme.getId(), schemeEntity);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        return this.getWorkflowSchemeObj(workflowScheme.getId());
    }

    @Nonnull
    public AssignableWorkflowScheme getWorkflowSchemeObj(@Nonnull Project project) {
        Assertions.notNull((String)"project", (Object)project);
        GenericValue schemeForProject = this.getSchemeForProject(project);
        if (schemeForProject != null) {
            return this.toWorkflowScheme(schemeForProject);
        }
        return this.defaultScheme;
    }

    @Nonnull
    public List<Project> getProjectsUsing(@Nonnull AssignableWorkflowScheme workflowScheme) {
        Assertions.notNull((String)"workflowScheme", (Object)workflowScheme);
        ImmutableList.Builder projects = new ImmutableList.Builder();
        for (Project project : this.projectManager.getProjectObjects()) {
            GenericValue schemeForProject = this.getSchemeForProject(project);
            if (schemeForProject == null) {
                if (!workflowScheme.isDefault()) continue;
                projects.add((Object)project);
                continue;
            }
            Long id = schemeForProject.getLong("id");
            if (id == null || !id.equals(workflowScheme.getId())) continue;
            projects.add((Object)project);
        }
        return projects.build();
    }

    private AssignableWorkflowScheme toWorkflowScheme(GenericValue genericValue) {
        if (genericValue == null) {
            return null;
        }
        String name = genericValue.getString("name");
        String description = genericValue.getString("description");
        Long id = genericValue.getLong("id");
        Map<String, String> map = this.getWorkflowMap(genericValue);
        return new WorkflowSchemeImpl(id, name, description, map);
    }

    private DraftWorkflowScheme toWorkflowScheme(DraftWorkflowSchemeStore.DraftWorkflowSchemeState state) {
        if (state == null) {
            return null;
        }
        ApplicationUser userByKey = this.userManager.getUserByKey(state.getLastModifiedUser());
        return new DraftWorkflowSchemeImpl(state, userByKey);
    }

    class ActiveWorkflowCache {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        @GuardedBy(value="lock")
        private Set<String> cache = null;

        ActiveWorkflowCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<String> get() throws GenericEntityException, WorkflowException {
            this.lock.readLock().lock();
            try {
                this.load();
                Set<String> set = this.cache;
                return set;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.lock.writeLock().lock();
            try {
                this.cache = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @GuardedBy(value="lock")
        private void load() throws GenericEntityException, WorkflowException {
            if (this.cache != null) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            List<GenericValue> schemes = DefaultWorkflowSchemeManager.this.getSchemes();
            for (GenericValue scheme : schemes) {
                if (DefaultWorkflowSchemeManager.this.getProjects(scheme).isEmpty()) continue;
                List<GenericValue> entities = DefaultWorkflowSchemeManager.this.getEntities(scheme);
                for (GenericValue schemeEntity : entities) {
                    set.add((String)schemeEntity.get(DefaultWorkflowSchemeManager.COLUMN_WORKFLOW));
                }
            }
            Collection projects = DefaultWorkflowSchemeManager.this.projectManager.getProjects();
            boolean checkComplete = false;
            for (GenericValue project : projects) {
                GenericValue workflowScheme = DefaultWorkflowSchemeManager.this.getWorkflowScheme(project);
                if (workflowScheme == null) {
                    set.add("jira");
                    checkComplete = true;
                } else {
                    List<GenericValue> issueTypes = DefaultWorkflowSchemeManager.this.getAllIssueTypes();
                    for (GenericValue issueType : issueTypes) {
                        String issueTypeId = issueType.getString("id");
                        JiraWorkflow workflow = DefaultWorkflowSchemeManager.this.getWorkflowFromScheme(workflowScheme, issueTypeId);
                        if (workflow.getName().equals("jira")) {
                            set.add("jira");
                            checkComplete = true;
                        }
                        if (!checkComplete) continue;
                        break;
                    }
                }
                if (!checkComplete) continue;
                break;
            }
            this.cache = Collections.unmodifiableSet(set);
        }
    }
}

