/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.rpc;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugin.rpc.XmlRpcModuleDescriptor;
import com.atlassian.jira.web.servlet.rpc.XmlRpcRequestProcessor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.io.InputStream;
import org.apache.xmlrpc.XmlRpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluggableXmlRpcRequestProcessor
implements XmlRpcRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PluggableXmlRpcRequestProcessor.class);
    private final XmlRpcServerConfigurator serverConfigurator;

    public PluggableXmlRpcRequestProcessor(PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        this.serverConfigurator = new XmlRpcServerConfigurator(pluginAccessor);
        eventPublisher.register((Object)this.serverConfigurator);
    }

    @Override
    public byte[] process(InputStream request) {
        return this.serverConfigurator.server().execute(request);
    }

    public static final class XmlRpcServerConfigurator {
        private final PluginAccessor pluginAccessor;
        private final ResettableLazyReference<XmlRpcServer> serverReference = new ResettableLazyReference<XmlRpcServer>(){

            protected XmlRpcServer create() throws Exception {
                return XmlRpcServerConfigurator.this.createServer();
            }
        };

        private XmlRpcServerConfigurator(PluginAccessor pluginAccessor) {
            this.pluginAccessor = pluginAccessor;
        }

        private XmlRpcServer createServer() {
            XmlRpcServer xmlrpc = new XmlRpcServer();
            try {
                this.addHandlers(xmlrpc);
            }
            catch (Throwable e) {
                logger.error("Error while initializing XML-RPC service", e);
            }
            return xmlrpc;
        }

        private void addHandlers(XmlRpcServer xmlrpc) {
            for (XmlRpcModuleDescriptor descriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(XmlRpcModuleDescriptor.class)) {
                if (logger.isInfoEnabled()) {
                    logger.info("Publishing to " + descriptor.getServicePath() + " module " + descriptor.getModuleClass());
                }
                xmlrpc.addHandler(descriptor.getServicePath(), descriptor.getModule());
            }
        }

        public XmlRpcServer server() {
            return (XmlRpcServer)this.serverReference.get();
        }

        @EventListener
        public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
            this.onPluginModuleEvent(event.getModule());
        }

        @EventListener
        public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
            this.onPluginModuleEvent(event.getModule());
        }

        private void onPluginModuleEvent(ModuleDescriptor<?> moduleDescriptor) {
            if (moduleDescriptor instanceof XmlRpcModuleDescriptor) {
                this.serverReference.reset();
            }
        }
    }
}

