/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.monitor.jmx;

import com.atlassian.jira.web.monitor.jmx.JMXException;
import java.lang.management.ManagementFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXBean<T> {
    private final Logger log = LoggerFactory.getLogger(JMXBean.class);
    private final T bean;
    private final ObjectName beanName;

    public JMXBean(T bean, String beanName) {
        try {
            this.bean = bean;
            this.beanName = new ObjectName(beanName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("The object name is invalid: " + beanName, e);
        }
    }

    public JMXBean<T> register() throws JMXException {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.bean, this.beanName);
            this.log.debug("Registered bean '{}' under name: {}", this.bean, (Object)this.beanName);
            return this;
        }
        catch (Exception e) {
            throw new JMXException("Unable to register bean in JMX: " + this.beanName, e);
        }
    }

    public JMXBean<T> unregister() throws JMXException {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.beanName);
            this.log.debug("Unregistered bean '{}' under name: {}", this.bean, (Object)this.beanName);
            return this;
        }
        catch (Exception e) {
            throw new JMXException("Unable to unregister bean from JMX: " + this.beanName, e);
        }
    }

    public T getBean() {
        return this.bean;
    }
}

