/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.greenhopper;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.plugin.license.PluginLicenseManager;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public class SetupGreenHopper
extends JiraWebActionSupport {
    private static final String COM_PYXIS_GREENHOPPER_JIRA = "com.pyxis.greenhopper.jira";
    private static final String GREENHOPPER_LICENSE_MANAGER = "greenhopper-license-manager";
    private final ExternalLinkUtil externalLinkUtil;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final JiraLicenseService licenseService;
    private String license;

    public SetupGreenHopper(ExternalLinkUtil externalLinkUtil, PluginAccessor pluginAccessor, JiraLicenseService licenseService, PluginController pluginController) {
        this.externalLinkUtil = externalLinkUtil;
        this.pluginAccessor = pluginAccessor;
        this.licenseService = licenseService;
        this.pluginController = pluginController;
    }

    public String doFetchLicense() throws Exception {
        return "input";
    }

    public String doReturnFromMAC() throws Exception {
        return "input";
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        super.doValidation();
    }

    private JiraLicenseService getLicenseService() {
        return ComponentManager.getComponent(JiraLicenseService.class);
    }

    protected String doExecute() throws Exception {
        this.pluginController.enablePlugins(new String[]{COM_PYXIS_GREENHOPPER_JIRA});
        Plugin plugin = this.pluginAccessor.getPlugin(COM_PYXIS_GREENHOPPER_JIRA);
        PluginLicenseManager pluginLicenseManager = (PluginLicenseManager)plugin.getModuleDescriptor(GREENHOPPER_LICENSE_MANAGER).getModule();
        try {
            pluginLicenseManager.setLicense(this.license);
        }
        catch (LicenseException e) {
            String m = this.getText(e.getMessage());
            this.addError("license", m);
            this.pluginController.disablePlugin(COM_PYXIS_GREENHOPPER_JIRA);
            return "error";
        }
        return this.getRedirect("/secure/MyJiraHome.jspa");
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getRequestLicenseURL() {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl((HttpServletRequest)this.request));
        url.append("/secure/SetupGreenHopper!returnFromMAC.jspa");
        String version = this.pluginAccessor.getPlugin(COM_PYXIS_GREENHOPPER_JIRA).getPluginInformation().getVersion();
        String organisation = this.licenseService.getLicense().getOrganisation();
        return this.externalLinkUtil.getProperty("external.link.greenhopper.license.view", Arrays.asList(version, "GreenHopper for JIRA 4: Evaluation", this.getServerId(), organisation, url.toString()));
    }
}

