/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.scheme.AbstractSelectProjectScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class SelectProjectWorkflowScheme
extends AbstractSelectProjectScheme {
    private final TaskManager taskManager;
    private TaskDescriptorBean currentActivateTask;
    private final JiraAuthenticationContext authenticationContext;
    private final OutlookDateManager outlookDateManager;
    private boolean draftMigration;

    public SelectProjectWorkflowScheme(TaskManager taskManager, JiraAuthenticationContext authenticationContext, OutlookDateManager outlookDateManager) {
        this.outlookDateManager = outlookDateManager;
        this.authenticationContext = authenticationContext;
        this.taskManager = taskManager;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return ManagerFactory.getWorkflowSchemeManager();
    }

    @Override
    public String getRedirectURL() {
        return null;
    }

    protected TaskManager getTaskManager() {
        return this.taskManager;
    }

    public boolean isAnyLiveTasks() {
        return !this.taskManager.getLiveTasks().isEmpty();
    }

    protected void initTaskDescriptorBean(TaskDescriptor taskDescriptor) {
        this.currentActivateTask = new TaskDescriptorBean(taskDescriptor, this.authenticationContext.getI18nHelper(), this.outlookDateManager, this.authenticationContext.getLoggedInUser());
    }

    protected TaskDescriptorBean getCurrentTask(boolean searchForTask) {
        EnterpriseWorkflowTaskContext taskContext;
        TaskDescriptor taskDescriptor;
        if (this.currentActivateTask == null && searchForTask && (taskDescriptor = this.taskManager.getLiveTask(taskContext = new EnterpriseWorkflowTaskContext(this.getProjectId(), this.getSchemeId(), this.isDraftMigration()))) != null) {
            this.initTaskDescriptorBean(taskDescriptor);
        }
        return this.currentActivateTask;
    }

    public TaskDescriptorBean getCurrentTask() {
        return this.getCurrentTask(true);
    }

    public boolean isDraftMigration() {
        return this.draftMigration;
    }

    public void setDraftMigration(boolean draftMigration) {
        this.draftMigration = draftMigration;
    }
}

