/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.user.GenericEditProfile;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@WebSudoRequired
public class EditUser
extends GenericEditProfile {
    String editName;
    User oldUser;
    private final UserService userService;
    private final UserManager userManager;
    private final FeatureManager featureManager;
    private final EventPublisher eventPublisher;
    private UserService.UpdateUserValidationResult updateUserValidationResult;

    public EditUser(UserService userService, UserManager userManager, UserPropertyManager userPropertyManager, FeatureManager featureManager, EventPublisher eventPublisher) {
        super(userPropertyManager);
        this.userService = userService;
        this.featureManager = featureManager;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void doValidation() {
        super.doValidation();
        User newUser = this.buildNewUser();
        this.updateUserValidationResult = this.userService.validateUpdateUser(newUser);
        this.addErrorCollection(this.updateUserValidationResult.getErrorCollection());
    }

    public boolean showProjectsUserLeadsError() {
        List projects;
        return !this.isActive() && (projects = ComponentAccessor.getProjectManager().getProjectsLeadBy(this.getEditedUser())).size() > 0;
    }

    public String projectsUserLeadsErrorMessage() {
        List projects = ComponentAccessor.getProjectManager().getProjectsLeadBy(this.getEditedUser());
        String projectList = this.getDisplayableProjectList(projects, "/roles");
        return this.getText("admin.errors.users.cannot.deactivate.due.to.project.lead", projectList);
    }

    public boolean showComponentsUserLeadsError() {
        Collection components;
        return !this.isActive() && (components = ComponentAccessor.getProjectComponentManager().findComponentsByLead(this.getEditName())).size() > 0;
    }

    public String componentsUserLeadsErrorMessage() {
        Collection components = ComponentAccessor.getProjectComponentManager().findComponentsByLead(this.getEditName());
        String projectList = this.getDisplayableProjectList(this.getProjectsFor(components), "/components");
        return this.getText("admin.errors.users.cannot.deactivate.due.to.component.lead", projectList);
    }

    private User buildNewUser() {
        ImmutableUser.Builder builder = ImmutableUser.newUser((User)this.getEditedUser());
        builder.displayName(this.getFullName());
        builder.emailAddress(this.getEmail());
        if (this.showActiveCheckbox()) {
            builder.active(this.isActive());
        }
        return builder.toUser();
    }

    private Collection<Project> getProjectsFor(Collection<ProjectComponent> components) {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        HashSet<Project> projects = new HashSet<Project>(components.size());
        for (ProjectComponent component : components) {
            projects.add(projectManager.getProjectObj(component.getProjectId()));
        }
        return projects;
    }

    private String getDisplayableProjectList(Collection<Project> projects, String projectConfigSection) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (Project project : projects) {
            if (count >= 5) {
                sb.append(", ...");
                break;
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("<a href=\"");
            sb.append(this.insertContextPath("/plugins/servlet/project-config/"));
            sb.append(project.getKey());
            sb.append(projectConfigSection);
            sb.append("\">");
            sb.append(project.getKey());
            sb.append("</a>");
            ++count;
        }
        return sb.toString();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.userService.updateUser(this.updateUserValidationResult);
        String result = this.getResult();
        if ("success".equals(result)) {
            this.eventPublisher.publish((Object)new UserProfileUpdatedEvent(this.updateUserValidationResult.getUser(), this.getLoggedInUser()));
            return this.getRedirect("ViewUser.jspa?name=" + URLEncoder.encode(this.editName, "UTF8"));
        }
        return result;
    }

    public String getEditName() {
        return this.editName;
    }

    public void setEditName(String editName) {
        this.editName = editName;
    }

    public boolean showActiveCheckbox() {
        if (this.featureManager.isEnabled(CoreFeatures.ON_DEMAND)) {
            return false;
        }
        Directory directory = this.userManager.getDirectory(Long.valueOf(this.getEditedUser().getDirectoryId()));
        return directory.getType() != DirectoryType.CONNECTOR;
    }

    @Override
    public User getEditedUser() {
        if (this.oldUser == null) {
            this.oldUser = this.crowdService.getUser(this.editName);
        }
        return this.oldUser;
    }
}

