/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.http.request;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CapturingRequestWrapper
extends HttpServletRequestWrapper {
    private final int maxCaptureBytes;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final OutputStreamWriter byteArrayWriter;
    private CapturingInputStream capturingInputStream;
    private CapturingBufferedReader capturingBufferedReader;
    private long writtenSoFar;

    public CapturingRequestWrapper(HttpServletRequest httpServletRequest, int maxCaptureBytes) {
        super(httpServletRequest);
        this.maxCaptureBytes = maxCaptureBytes;
        this.byteArrayOutputStream = new ByteArrayOutputStream(maxCaptureBytes);
        this.byteArrayWriter = new OutputStreamWriter(this.byteArrayOutputStream);
        this.writtenSoFar = 0L;
    }

    public byte[] getBytes() {
        try {
            this.byteArrayWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.byteArrayOutputStream.toByteArray();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.capturingInputStream == null) {
            this.capturingInputStream = new CapturingInputStream(super.getInputStream());
        }
        return this.capturingInputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.capturingBufferedReader == null) {
            this.capturingBufferedReader = new CapturingBufferedReader(super.getReader());
        }
        return this.capturingBufferedReader;
    }

    private class CapturingInputStream
    extends ServletInputStream {
        private final ServletInputStream delegate;

        private CapturingInputStream(ServletInputStream delegate) {
            this.delegate = delegate;
        }

        private void capture(byte[] buf, int off, int len) {
            long roomLeft = (long)CapturingRequestWrapper.this.maxCaptureBytes - CapturingRequestWrapper.this.writtenSoFar;
            if (roomLeft > 0L) {
                len = (int)Math.min(roomLeft, (long)len);
                CapturingRequestWrapper.this.writtenSoFar += len;
                CapturingRequestWrapper.this.byteArrayOutputStream.write(buf, off, len);
            }
        }

        public int read() throws IOException {
            int c = this.delegate.read();
            if (c > -1) {
                this.capture(new byte[]{(byte)c}, 0, 1);
            }
            return c;
        }

        public int read(byte[] b) throws IOException {
            int totalread = this.delegate.read(b);
            if (totalread > 0) {
                this.capture(b, 0, totalread);
            }
            return totalread;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int totalread = this.delegate.read(b, off, len);
            if (totalread > 0) {
                this.capture(b, off, totalread);
            }
            return totalread;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int totalread = this.delegate.readLine(b, off, len);
            if (totalread > 0) {
                this.capture(b, off, totalread);
            }
            return totalread;
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    private class CapturingBufferedReader
    extends BufferedReader {
        private final BufferedReader delegate;

        private CapturingBufferedReader(BufferedReader delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        private void capture(char[] buf) {
            this.capture(buf, 0, buf.length);
        }

        private void capture(char[] buf, int off, int len) {
            long roomLeft = (long)CapturingRequestWrapper.this.maxCaptureBytes - CapturingRequestWrapper.this.writtenSoFar;
            if (roomLeft > 0L) {
                len = (int)Math.min(roomLeft, (long)len);
                CapturingRequestWrapper.this.writtenSoFar += len;
                try {
                    CapturingRequestWrapper.this.byteArrayWriter.write(buf, off, len);
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }

        @Override
        public int read() throws IOException {
            int c = this.delegate.read();
            if (c != -1) {
                this.capture(new char[]{(char)c}, 0, 1);
            }
            return c;
        }

        @Override
        public String readLine() throws IOException {
            String s = this.delegate.readLine();
            if (s != null && s.length() > 0) {
                this.capture(s.toCharArray());
            }
            return s;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            int totalread = this.delegate.read(cbuf);
            if (totalread > 0) {
                this.capture(cbuf, 0, totalread);
            }
            return totalread;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int totalread = this.delegate.read(cbuf, off, len);
            if (totalread > 0) {
                this.capture(cbuf, off, totalread);
            }
            return totalread;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.delegate.ready();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.delegate.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

