/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream streamForZipFileEntry(File zipFile, String entryName) throws IOException {
        final ZipFile file = new ZipFile(zipFile.getAbsolutePath());
        InputStream underlyingStream = null;
        try {
            ZipArchiveEntry entry = file.getEntry(entryName);
            if (entry == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            underlyingStream = file.getInputStream(entry);
        }
        finally {
            if (underlyingStream == null) {
                ZipFile.closeQuietly((ZipFile)file);
            }
        }
        return new FilterInputStream(underlyingStream){

            @Override
            public void close() throws IOException {
                super.close();
                file.close();
            }
        };
    }
}

