/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.util.concurrent.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultUserManager
implements UserManager {
    private static final Logger log = Logger.getLogger(DefaultUserManager.class);
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;

    public DefaultUserManager(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager) {
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
    }

    public int getTotalUserCount() {
        Iterable<User> crowdUsers = this.getAllUsersFromCrowd();
        if (crowdUsers instanceof Collection) {
            return ((Collection)crowdUsers).size();
        }
        int count = 0;
        for (User crowdUser : crowdUsers) {
            ++count;
        }
        return count;
    }

    public Collection<User> getUsers() {
        Iterable<User> crowdUsers = this.getAllUsersFromCrowd();
        if (crowdUsers instanceof Collection) {
            return (Collection)crowdUsers;
        }
        LinkedList<User> users = new LinkedList<User>();
        for (User user : crowdUsers) {
            users.add(user);
        }
        return users;
    }

    private Iterable<User> getAllUsersFromCrowd() {
        Collection<Object> allUsers;
        long startTime = System.currentTimeMillis();
        LinkedList<Directory> activeDirectories = new LinkedList<Directory>();
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (!directory.isActive()) continue;
            activeDirectories.add(0, directory);
        }
        UserQuery query = new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        if (activeDirectories.size() == 1) {
            try {
                allUsers = this.directoryManager.searchUsers(((Directory)activeDirectories.get(0)).getId().longValue(), (EntityQuery)query);
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                throw new OperationFailedException((Throwable)e);
            }
        } else {
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (Directory activeDirectory : activeDirectories) {
                try {
                    List users = this.directoryManager.searchUsers(activeDirectory.getId().longValue(), (EntityQuery)query);
                    for (User user : users) {
                        userMap.put(IdentifierUtils.toLowerCase((String)user.getName()), user);
                    }
                }
                catch (DirectoryNotFoundException e) {
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    log.error((Object)("Unexpected error retrieving users from directory " + activeDirectory.getId()), (Throwable)e);
                }
            }
            allUsers = userMap.values();
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Found " + allUsers.size() + " users in " + (System.currentTimeMillis() - startTime) + "ms."));
        }
        return allUsers;
    }

    public Set<User> getAllUsers() {
        HashSet<User> allUsers = new HashSet<User>();
        for (User user : this.getUsers()) {
            allUsers.add(user);
        }
        return allUsers;
    }

    private User getCrowdUser(String userName) {
        if (userName == null) {
            return null;
        }
        return this.crowdService.getUser(userName);
    }

    public User getUser(String userName) {
        return this.getUserObject(userName);
    }

    public User getUserObject(@Nullable String userName) {
        return this.getCrowdUser(userName);
    }

    public ApplicationUser getUserByKey(@Nullable String userKey) {
        return this.getUserByName(userKey);
    }

    public ApplicationUser getUserByName(@Nullable String userName) {
        if (userName == null) {
            return null;
        }
        return new DelegatingApplicationUser(IdentifierUtils.toLowerCase((String)userName), this.getUserEvenWhenUnknown(userName));
    }

    public User findUserInDirectory(String userName, Long directoryId) {
        try {
            return ((DirectoryManager)ComponentAccessor.getComponentOfType(DirectoryManager.class)).findUserByName(directoryId.longValue(), userName);
        }
        catch (DirectoryNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public User getUserEvenWhenUnknown(String userName) {
        if (userName == null) {
            return null;
        }
        User user = this.getCrowdUser(userName);
        if (user == null) {
            user = new ImmutableUser.Builder().name(userName).displayName(userName).active(false).toUser();
        }
        return user;
    }

    public boolean canUpdateUser(User user) {
        if (user == null) {
            return false;
        }
        return this.userDirectoryAllowsUpdateUser(user);
    }

    public void updateUser(User user) {
        try {
            this.crowdService.updateUser(user);
            ComponentAccessor.getUserUtil().clearActiveUserCount();
        }
        catch (InvalidUserException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (OperationNotPermittedException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    public boolean canUpdateUserPassword(User user) {
        if (!this.userDirectoryAllowsUpdateUser(user)) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return this.canDirectoryUpdateUserPassword(directory);
    }

    private boolean userDirectoryAllowsUpdateUser(User user) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    public boolean canUpdateGroupMembershipForUser(User user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    public Collection<Group> getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        Iterable crowdGroups = this.crowdService.search((Query)query);
        if (crowdGroups instanceof Collection) {
            return (Collection)crowdGroups;
        }
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (Group group : crowdGroups) {
            groups.add(group);
        }
        return groups;
    }

    public Set<Group> getAllGroups() {
        Collection<Group> groups = this.getGroups();
        if (groups instanceof Set) {
            return (Set)groups;
        }
        return new LinkedHashSet<Group>(groups);
    }

    private Group getCrowdGroup(String groupName) {
        if (groupName == null) {
            return null;
        }
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroup(String groupName) {
        return this.getCrowdGroup(groupName);
    }

    public Group getGroupObject(@Nullable String groupName) {
        return this.getCrowdGroup(groupName);
    }

    public List<Directory> getWritableDirectories() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        ArrayList<Directory> writableDirectories = new ArrayList<Directory>(allDirectories.size());
        for (Directory directory : allDirectories) {
            if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER) || !directory.isActive()) continue;
            writableDirectories.add(directory);
        }
        return writableDirectories;
    }

    public boolean hasWritableDirectory() {
        return this.getWritableDirectories().size() > 0;
    }

    public boolean hasPasswordWritableDirectory() {
        List<Directory> writableDirectories = this.getWritableDirectories();
        for (Directory directory : writableDirectories) {
            if (!this.canDirectoryUpdateUserPassword(directory)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupWritableDirectory() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        for (Directory directory : allDirectories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(OperationType.CREATE_GROUP)) continue;
            return true;
        }
        return false;
    }

    public Directory getDirectory(Long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId.longValue());
    }

    public boolean canDirectoryUpdateUserPassword(Directory directory) {
        if (directory == null) {
            return false;
        }
        if (directory.getType() == DirectoryType.DELEGATING) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }
}

