/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.distiller;

import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DistilledSchemeResults {
    private final List distilledSchemeResults;
    private final Collection unDistilledSchemes;
    private final String schemeType;

    public DistilledSchemeResults(String schemeType) {
        this.schemeType = schemeType;
        this.distilledSchemeResults = new ArrayList();
        this.unDistilledSchemes = new ArrayList();
    }

    public DistilledSchemeResults(Collection distilledSchemeResults, Collection unDistilledSchemes, String schemeType) {
        this.schemeType = schemeType;
        this.distilledSchemeResults = distilledSchemeResults == null ? new ArrayList() : new ArrayList(distilledSchemeResults);
        this.unDistilledSchemes = unDistilledSchemes == null ? new ArrayList() : unDistilledSchemes;
    }

    public Collection getDistilledSchemes() {
        ArrayList<Scheme> distilledSchemes = new ArrayList<Scheme>();
        for (DistilledSchemeResult distilledSchemeResult : this.distilledSchemeResults) {
            distilledSchemes.add(distilledSchemeResult.getResultingScheme());
        }
        return distilledSchemes;
    }

    public void addDistilledSchemeResult(DistilledSchemeResult distilledSchemeResult) {
        this.distilledSchemeResults.add(distilledSchemeResult);
    }

    public Collection getDistilledSchemeResults() {
        Collections.sort(this.distilledSchemeResults, new DistilledSchemeResultComparator());
        return this.distilledSchemeResults;
    }

    public void addUndistilledScheme(Scheme scheme) {
        this.unDistilledSchemes.add(scheme);
    }

    public Collection getUnDistilledSchemes() {
        return Collections.unmodifiableCollection(this.unDistilledSchemes);
    }

    public String getSchemeType() {
        return this.schemeType;
    }

    private static class DistilledSchemeResultComparator
    implements Comparator,
    Serializable {
        static final long serialVersionUID = -7050803095518619538L;

        private DistilledSchemeResultComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 != null && o2 != null) {
                DistilledSchemeResult distilledSchemeResult1 = (DistilledSchemeResult)o1;
                DistilledSchemeResult distilledSchemeResult2 = (DistilledSchemeResult)o2;
                Scheme resultingScheme1 = distilledSchemeResult1.getResultingScheme();
                Scheme resultingScheme2 = distilledSchemeResult2.getResultingScheme();
                if (resultingScheme1 != null && resultingScheme2 != null) {
                    return resultingScheme1.getName().compareTo(resultingScheme2.getName());
                }
            }
            return 0;
        }
    }
}

