/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.AbstractSchemeAwareAction;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.google.common.base.Strings;
import java.util.List;

public abstract class AbstractDeleteScheme
extends AbstractSchemeAwareAction {
    private boolean confirmed;
    private String name;
    private String description;

    public String doDefault() throws Exception {
        Scheme scheme = this.getSchemeObject();
        if (scheme == null) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.nonexistent.scheme"));
            return "input";
        }
        this.name = scheme.getName();
        this.description = Strings.emptyToNull((String)scheme.getDescription());
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getSchemeId() == null) {
            this.addError("schemeId", this.getText("admin.errors.deletescheme.no.scheme.specified"));
        }
        if (this.getSchemeManager().getDefaultSchemeObject() != null && this.getSchemeManager().getDefaultSchemeObject().getId().equals(this.getSchemeId())) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.cannot.delete.default"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.confirmation"));
        }
        if (this.isActive()) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.cannot.delete.active", this.getSchemeObject().getName()));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Scheme scheme = this.getSchemeObject();
        if (scheme != null) {
            List<Project> projects = this.getProjects(scheme);
            for (Project project : projects) {
                this.getSchemeManager().removeSchemesFromProject(project);
                this.getSchemeManager().addDefaultSchemeToProject(project);
            }
            this.getSchemeManager().deleteScheme(this.getSchemeId());
        }
        return this.returnCompleteWithInlineRedirect(this.getRedirectURL());
    }

    public boolean isActive() {
        return !this.getProjects(this.getSchemeObject()).isEmpty();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Project> getProjects(Scheme scheme) {
        return this.getSchemeManager().getProjects(scheme);
    }
}

