/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectHistoryLinkFactory
implements SimpleLinkFactory {
    private final UserProjectHistoryManager userHistoryManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private String relativeUrl = null;
    private final String adminSection = "admin_project_menu/recent_project_section";
    private Boolean showCurrentProject = false;
    private boolean isInAdminSection = false;
    public static final int MAX_RECENT_PROJECTS_TO_SHOW = 5;

    public ProjectHistoryLinkFactory(VelocityRequestContextFactory velocityRequestContextFactory, UserProjectHistoryManager userHistoryManager, I18nHelper.BeanFactory beanFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.userHistoryManager = userHistoryManager;
        this.beanFactory = beanFactory;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
        if (descriptor.getSection().equals("admin_project_menu/recent_project_section")) {
            this.relativeUrl = "/plugins/servlet/project-config/";
            this.showCurrentProject = true;
            this.isInAdminSection = true;
        } else {
            this.relativeUrl = "/browse/";
            this.showCurrentProject = false;
            this.isInAdminSection = false;
        }
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        ProjectAction projectAction = this.isInAdminSection ? ProjectAction.EDIT_PROJECT_CONFIG : ProjectAction.VIEW_ISSUES;
        List history = this.userHistoryManager.getProjectHistoryWithPermissionChecks(projectAction, user);
        ArrayList<SimpleLinkImpl> links = new ArrayList<SimpleLinkImpl>();
        if (history != null && !history.isEmpty()) {
            VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            String baseUrl = requestContext.getBaseUrl();
            Project currentProject = this.userHistoryManager.getCurrentProject(10, user);
            I18nHelper i18n = this.beanFactory.getInstance(user);
            for (Project project : history) {
                if (!this.showCurrentProject.booleanValue() && project.equals(currentProject)) continue;
                Long projectId = project.getId();
                String name = project.getName();
                String key = project.getKey();
                String iconUrl = null;
                if (project.getGenericValue().getLong("avatar") != null) {
                    Avatar avatar = project.getAvatar();
                    iconUrl = baseUrl + "/secure/projectavatar?pid=" + projectId + "&avatarId=" + avatar.getId() + "&size=small";
                }
                links.add(new SimpleLinkImpl("proj_lnk_" + projectId, name + " (" + key + ")", i18n.getText("tooltip.browseproject.specified", name), iconUrl, null, null, baseUrl + this.relativeUrl + key, null));
            }
        }
        return links.subList(0, Math.min(5, links.size()));
    }
}

