/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InvolvedPluginsTracker {
    private final Set<PluginInfo> pluginsInvolved = new CopyOnWriteArraySet<PluginInfo>();

    private PluginInfo toInfo(Plugin plugin) {
        return new PluginInfo(plugin.getKey(), plugin.getPluginInformation().getVersion());
    }

    public void trackInvolvedPlugin(Plugin plugin) {
        this.pluginsInvolved.add(this.toInfo((Plugin)Assertions.notNull((String)"plugin", (Object)plugin)));
    }

    public void trackInvolvedPlugin(ModuleDescriptor moduleDescriptor) {
        this.pluginsInvolved.add(this.toInfo(((ModuleDescriptor)Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor)).getPlugin()));
    }

    public boolean isPluginInvolved(Plugin plugin) {
        return this.pluginsInvolved.contains(this.toInfo((Plugin)Assertions.notNull((String)"plugin", (Object)plugin)));
    }

    public boolean isPluginInvolved(ModuleDescriptor moduleDescriptor) {
        return this.pluginsInvolved.contains(this.toInfo(((ModuleDescriptor)Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor)).getPlugin()));
    }

    public boolean isPluginWithModuleDescriptor(ModuleDescriptor moduleDescriptor, Class<? extends ModuleDescriptor> targetModuleClass) {
        return this.isPluginWithModuleDescriptor(((ModuleDescriptor)Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor)).getPlugin(), targetModuleClass);
    }

    public boolean isPluginWithModuleDescriptor(Plugin plugin, Class<? extends ModuleDescriptor> targetModuleClass) {
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            Class<?> moduleClass = moduleDescriptor.getClass();
            if (!targetModuleClass.isAssignableFrom(moduleClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginWithResourceType(Plugin plugin, String pluginResourceType) {
        Resources.TypeFilter filter = new Resources.TypeFilter(pluginResourceType);
        if (Iterables.any((Iterable)plugin.getResourceDescriptors(), (Predicate)filter)) {
            return true;
        }
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            if (!Iterables.any((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)filter)) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginWithResourceType(ModuleDescriptor moduleDescriptor, String pluginResourceType) {
        return this.isPluginWithResourceType(((ModuleDescriptor)Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor)).getPlugin(), pluginResourceType);
    }

    public Set<PluginInfo> getInvolvedPluginKeys() {
        return Sets.newLinkedHashSet(this.pluginsInvolved);
    }

    public void clear() {
        this.pluginsInvolved.clear();
    }

    public int hashCode() {
        return ((Object)this.pluginsInvolved).hashCode();
    }

    public String toString() {
        return super.toString() + " " + this.pluginsInvolved.toString();
    }

    public static class PluginInfo
    implements Comparable<PluginInfo> {
        private final String pluginKey;
        private final String pluginVersion;

        public PluginInfo(String pluginKey, String pluginVersion) {
            this.pluginKey = (String)Assertions.notNull((String)"pluginKey", (Object)pluginKey);
            this.pluginVersion = (String)Assertions.notNull((String)"pluginVersion", (Object)pluginVersion);
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        @Override
        public int compareTo(PluginInfo that) {
            int rc = this.pluginKey.compareTo(that.pluginKey);
            if (rc == 0) {
                rc = this.pluginVersion.compareTo(that.pluginVersion);
            }
            return rc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginInfo that = (PluginInfo)o;
            return this.pluginKey.equals(that.pluginKey) && this.pluginVersion.equals(that.pluginVersion);
        }

        public int hashCode() {
            int result = this.pluginKey.hashCode();
            result = 31 * result + this.pluginVersion.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

