/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.rpc;

import com.atlassian.jira.plugin.rpc.RpcModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import org.dom4j.Element;

public class SoapModuleDescriptor
extends RpcModuleDescriptor {
    private Class<?> publishedInterface;
    private String interfaceClassName;

    public SoapModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"published-interface").withError("The published-interface element is required for SOAP module descriptors")});
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.interfaceClassName = element.element("published-interface").getTextTrim();
    }

    @Override
    public void enabled() {
        try {
            this.publishedInterface = this.plugin.loadClass(this.interfaceClassName, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException ex) {
            throw new PluginException("Could not load published interface '" + this.interfaceClassName + "'.", (Throwable)ex);
        }
        super.enabled();
    }

    @Override
    public void disabled() {
        super.disabled();
        this.publishedInterface = null;
    }

    public Class<?> getPublishedInterface() {
        if (this.publishedInterface == null) {
            throw new IllegalStateException("The published interface '" + this.interfaceClassName + "' is not currently loaded. This means the plugin has not been successfully enabled.");
        }
        return this.publishedInterface;
    }
}

