/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report;

import com.atlassian.jira.plugin.AbstractConfigurableModuleDescriptor;
import com.atlassian.jira.plugin.report.Report;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import org.dom4j.Element;

public class ReportModuleDescriptorImpl
extends AbstractConfigurableModuleDescriptor<Report>
implements ReportModuleDescriptor {
    private Report report;
    private String label = "Unknown";
    private String labelKey;

    public ReportModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    protected boolean isSingletonByDefault() {
        return false;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element labelEl = element.element("label");
        if (labelEl != null) {
            if (labelEl.attribute("key") != null) {
                this.labelKey = labelEl.attributeValue("key");
            } else {
                this.label = labelEl.getTextTrim();
            }
        }
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(Report.class);
    }

    @Override
    public Report getModule() {
        if (!this.isSingleton()) {
            return this.makeModule();
        }
        if (this.report == null) {
            this.report = this.makeModule();
        }
        return this.report;
    }

    private Report makeModule() {
        Plugin plugin = this.getPlugin();
        Report reportModule = plugin instanceof AutowireCapablePlugin ? (Report)((AutowireCapablePlugin)plugin).autowire(this.getModuleClass()) : (Report)JiraUtils.loadComponent(this.getModuleClass());
        reportModule.init((ReportModuleDescriptor)this);
        return reportModule;
    }

    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    public String getLabelKey() {
        return this.labelKey;
    }
}

