/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.myjirahome;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeLinker;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomePreference;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MyJiraHomeLinkerImpl
implements MyJiraHomeLinker {
    private final PluginAccessor pluginAccessor;
    private final MyJiraHomePreference myJiraHomePreference;

    public MyJiraHomeLinkerImpl(@Nonnull PluginAccessor pluginAccessor, @Nonnull MyJiraHomePreference myJiraHomePreference) {
        this.pluginAccessor = pluginAccessor;
        this.myJiraHomePreference = myJiraHomePreference;
    }

    @Override
    @Nonnull
    public String getHomeLink(@Nullable User user) {
        String completePluginModuleKey = this.myJiraHomePreference.findHome(user);
        try {
            if (!this.pluginAccessor.isPluginModuleEnabled(completePluginModuleKey)) {
                return "/secure/Dashboard.jspa";
            }
            WebLink link = this.getWebLinkFromWebItemModuleDescriptor(completePluginModuleKey);
            if (link != null) {
                return link.getRenderedUrl(Collections.emptyMap());
            }
            return "/secure/Dashboard.jspa";
        }
        catch (IllegalArgumentException e) {
            return "/secure/Dashboard.jspa";
        }
    }

    @Nullable
    private WebLink getWebLinkFromWebItemModuleDescriptor(@Nonnull String completePluginModuleKey) {
        WebItemModuleDescriptor webItemModuleDescriptor = this.getWebItemModuleDescriptorFromKey(completePluginModuleKey);
        if (webItemModuleDescriptor != null) {
            return webItemModuleDescriptor.getLink();
        }
        return null;
    }

    @Nullable
    private WebItemModuleDescriptor getWebItemModuleDescriptorFromKey(@Nonnull String completePluginModuleKey) {
        ModuleDescriptor pluginModule = this.pluginAccessor.getPluginModule(completePluginModuleKey);
        if (pluginModule instanceof WebItemModuleDescriptor) {
            return (WebItemModuleDescriptor)pluginModule;
        }
        return null;
    }
}

