/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.filters.IssueIdFilter;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.jql.operand.EmptyWasClauseOperandHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.HistoryPredicateQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.ChangeHistoryFieldIdResolver;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operator.Operator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class WasClauseQueryFactory {
    private static final Logger log = Logger.getLogger(WasClauseQueryFactory.class);
    private final SearchProviderFactory searchProviderFactory;
    private final JqlOperandResolver operandResolver;
    private final HistoryPredicateQueryFactory wasPredicateQueryFactory;
    private final EmptyWasClauseOperandHandler emptyWasClauseOperandHandler;
    private final ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver;

    public WasClauseQueryFactory(SearchProviderFactory searchProviderFactory, JqlOperandResolver operandResolver, HistoryPredicateQueryFactory wasPredicateQueryFactory, EmptyWasClauseOperandHandler emptyWasClauseOperandHandler, ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver) {
        this.searchProviderFactory = searchProviderFactory;
        this.operandResolver = operandResolver;
        this.changeHistoryFieldIdResolver = changeHistoryFieldIdResolver;
        this.wasPredicateQueryFactory = wasPredicateQueryFactory;
        this.emptyWasClauseOperandHandler = emptyWasClauseOperandHandler;
    }

    public QueryFactoryResult create(User searcher, WasClause clause) {
        ConstantScoreQuery issueQuery;
        Query historyQuery = this.makeQuery(searcher, clause);
        IndexSearcher historySearcher = this.searchProviderFactory.getSearcher("changes");
        final HashSet<String> queryIds = new HashSet<String>();
        final HashSet allIssueIds = new HashSet();
        DocumentHitCollector Collector2 = new DocumentHitCollector(historySearcher){

            public void collect(Document doc) {
                queryIds.add(doc.get("issue_id"));
            }
        };
        DocumentHitCollector allDocsCollector = new DocumentHitCollector(historySearcher){

            public void collect(Document doc) {
                allIssueIds.add(doc.get("issue_id"));
            }
        };
        try {
            HashSet<String> issueIds;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running history query (" + clause + "): " + historyQuery));
            }
            historySearcher.search(historyQuery, (Collector)Collector2);
            if (clause.getOperator() == Operator.WAS || clause.getOperator() == Operator.WAS_IN) {
                issueIds = queryIds;
            } else {
                historySearcher.search((Query)new MatchAllDocsQuery(), (Collector)allDocsCollector);
                allIssueIds.removeAll(queryIds);
                issueIds = allIssueIds;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("History query returned: " + issueIds));
            }
            issueQuery = new ConstantScoreQuery((Filter)new IssueIdFilter(issueIds));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new QueryFactoryResult((Query)issueQuery);
    }

    private Query makeQuery(User searcher, WasClause clause) {
        BooleanQuery outerWasQuery = new BooleanQuery();
        boolean isEmptyOperand = clause.getOperand() instanceof EmptyOperand;
        ArrayList<QueryLiteral> literals = new ArrayList<QueryLiteral>();
        if (isEmptyOperand) {
            literals.addAll(this.emptyWasClauseOperandHandler.getEmptyValue(clause));
        } else if (clause.getOperand() instanceof MultiValueOperand) {
            literals.addAll(this.operandResolver.getValues(searcher, clause.getOperand(), (TerminalClause)clause));
        } else if (clause.getOperand() instanceof FunctionOperand) {
            literals.addAll(this.operandResolver.getValues(searcher, clause.getOperand(), (TerminalClause)clause));
        } else {
            literals.add(this.operandResolver.getSingleValue(searcher, clause.getOperand(), (TerminalClause)clause));
        }
        for (QueryLiteral literal : literals) {
            BooleanQuery wasQuery = new BooleanQuery();
            Collection ids = this.changeHistoryFieldIdResolver.resolveIdsForField(clause.getField(), literal, isEmptyOperand);
            for (String id : ids) {
                TermQuery fromQuery = this.createTermQuery(clause, id, "ch_oldvalue");
                TermQuery toQuery = this.createTermQuery(clause, id, "ch_newvalue");
                if (id != null && clause.getPredicate() == null) {
                    wasQuery.add((Query)fromQuery, BooleanClause.Occur.SHOULD);
                }
                wasQuery.add((Query)toQuery, BooleanClause.Occur.SHOULD);
            }
            if (clause.getPredicate() != null) {
                BooleanQuery wasPredicateQuery = this.wasPredicateQueryFactory.makePredicateQuery(searcher, clause.getField().toLowerCase(), clause.getPredicate(), false);
                BooleanQuery wasWithPredicateQuery = new BooleanQuery();
                wasWithPredicateQuery.add((Query)wasQuery, BooleanClause.Occur.MUST);
                wasWithPredicateQuery.add((Query)wasPredicateQuery, BooleanClause.Occur.MUST);
                wasQuery = wasWithPredicateQuery;
            }
            outerWasQuery.add((Query)wasQuery, BooleanClause.Occur.SHOULD);
        }
        return outerWasQuery;
    }

    private TermQuery createTermQuery(WasClause clause, String value, String documentField) {
        return new TermQuery(new Term(clause.getField().toLowerCase() + "." + documentField, this.encodeProtocol(value)));
    }

    private String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }
}

