/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class IssueSecurityLevelManagerImpl
implements IssueSecurityLevelManager {
    protected final Logger log = Logger.getLogger(IssueSecurityLevelManagerImpl.class);
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityTypeManager securityTypeManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final EntityEngine entityEngine;
    private final ConcurrentMap<CacheKey, List<GenericValue>> projectAndUserToSecurityLevelCache;

    public IssueSecurityLevelManagerImpl(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager securityTypeManager, ProjectManager projectManager, PermissionManager permissionManager, EntityEngine entityEngine) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.securityTypeManager = securityTypeManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.entityEngine = entityEngine;
        this.projectAndUserToSecurityLevelCache = new MapMaker().concurrencyLevel(16).expireAfterAccess(30L, TimeUnit.MINUTES).makeMap();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearUsersLevels();
    }

    public List<GenericValue> getSchemeIssueSecurityLevels(Long schemeId) {
        return this.internSecurityLevelFields(ComponentAccessor.getOfBizDelegator().findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)schemeId), (List)ImmutableList.of((Object)"name")));
    }

    public List<IssueSecurityLevel> getIssueSecurityLevels(long schemeId) {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).whereEqual("scheme", schemeId).orderBy("name");
    }

    public GenericValue getIssueSecurity(Long id) {
        return this.internSecurityLevelFields(ComponentAccessor.getOfBizDelegator().findById("SchemeIssueSecurityLevels", id));
    }

    public IssueSecurityLevel getSecurityLevel(long id) {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).findById(id);
    }

    public boolean schemeIssueSecurityExists(Long id) {
        return this.getIssueSecurity(id) != null;
    }

    public String getIssueSecurityName(Long id) {
        GenericValue issueSecurity = this.getIssueSecurity(id);
        return issueSecurity == null ? null : issueSecurity.getString("name");
    }

    public String getIssueSecurityDescription(Long id) {
        GenericValue issueSecurity = this.getIssueSecurity(id);
        return issueSecurity == null ? null : issueSecurity.getString("description");
    }

    public List<GenericValue> getUsersSecurityLevels(GenericValue entity, User user) throws GenericEntityException {
        if (entity != null) {
            if (entity.getEntityName().equals("Project")) {
                return this.getUsersSecurityLevels(this.projectAndUserToSecurityLevelCache, entity, entity, user);
            }
            if (entity.getEntityName().equals("Issue")) {
                GenericValue project = this.projectManager.getProject(entity);
                return this.getUsersSecurityLevels(this.projectAndUserToSecurityLevelCache, project, project, user);
            }
        }
        return null;
    }

    private List<GenericValue> getUsersSecurityLevels(ConcurrentMap<CacheKey, List<GenericValue>> cache, GenericValue project, GenericValue entity, User user) throws GenericEntityException {
        Long entityId = entity.getLong("id");
        CacheKey cacheKey = new CacheKey(entityId, user);
        List<GenericValue> securityLevels = (List<GenericValue>)cache.get(cacheKey);
        if (securityLevels == null) {
            securityLevels = this.getUsersSecurityLevelsUncached(project, entity, user);
            cache.put(cacheKey, securityLevels);
        }
        return securityLevels;
    }

    private List<GenericValue> getUsersSecurityLevelsUncached(GenericValue project, GenericValue entity, User user) throws GenericEntityException {
        GenericValue scheme = EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(project));
        if (scheme == null) {
            return ImmutableList.of();
        }
        List securities = this.issueSecuritySchemeManager.getEntities(scheme);
        Map types = this.securityTypeManager.getTypes();
        ArrayList<GenericValue> levels = new ArrayList<GenericValue>();
        for (GenericValue security : securities) {
            GenericValue level;
            SchemeType type;
            if (this.levelExists(levels, security.getLong("security")) || (type = (SchemeType)types.get(security.getString("type"))) == null || !this.hasPermission(entity, user, security, type) || (level = this.getIssueSecurityLevel(security.getLong("security"))) == null) continue;
            levels.add(level);
        }
        Collections.sort(levels, SortByNameComparator.INSTANCE);
        return ImmutableList.copyOf(levels);
    }

    private boolean hasPermission(GenericValue entity, User user, GenericValue security, SchemeType type) {
        return user != null ? type.hasPermission(entity, security.getString("parameter"), user, false) : type.hasPermission(entity, security.getString("parameter"));
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Issue issue, User user) {
        try {
            List<GenericValue> genericValues = this.getUsersSecurityLevels(issue.getGenericValue(), user);
            return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Project project, User user) {
        try {
            List<GenericValue> genericValues = this.getUsersSecurityLevels(project.getGenericValue(), user);
            return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<GenericValue> getAllUsersSecurityLevels(User user) throws GenericEntityException {
        Collection projectGVs = this.permissionManager.getProjects(10, user);
        HashSet<GenericValue> securityLevels = new HashSet<GenericValue>();
        for (GenericValue projectGV : projectGVs) {
            securityLevels.addAll(this.getUsersSecurityLevels(projectGV, user));
        }
        return securityLevels;
    }

    public Collection<IssueSecurityLevel> getAllSecurityLevelsForUser(User user) {
        Collection projects = this.permissionManager.getProjectObjects(10, user);
        HashSet<IssueSecurityLevel> securityLevels = new HashSet<IssueSecurityLevel>();
        for (Project project : projects) {
            securityLevels.addAll(this.getUsersSecurityLevels(project, user));
        }
        return securityLevels;
    }

    public Collection<GenericValue> getAllSecurityLevels() throws GenericEntityException {
        List schemes = this.issueSecuritySchemeManager.getSchemes();
        LinkedHashSet<GenericValue> allLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getSchemeIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<IssueSecurityLevel> getAllIssueSecurityLevels() {
        List schemes;
        try {
            schemes = this.issueSecuritySchemeManager.getSchemes();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        LinkedHashSet<IssueSecurityLevel> allLevels = new LinkedHashSet<IssueSecurityLevel>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<GenericValue> getUsersSecurityLevelsByName(User user, String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllUsersSecurityLevels(user));
    }

    public Collection<IssueSecurityLevel> getSecurityLevelsForUserByName(User user, String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllSecurityLevelsForUser(user));
    }

    public Collection<GenericValue> getSecurityLevelsByName(String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllSecurityLevels());
    }

    public Collection<IssueSecurityLevel> getIssueSecurityLevelsByName(String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllIssueSecurityLevels());
    }

    private Collection<GenericValue> _getSecurityLevelsByName(final String securityLevelName, Collection<GenericValue> securityLevels) throws GenericEntityException {
        Predicate<GenericValue> namePredicate = new Predicate<GenericValue>(){

            public boolean apply(GenericValue input) {
                return securityLevelName.equalsIgnoreCase(input.getString("name"));
            }
        };
        LinkedHashSet<GenericValue> filteredSecurityLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue levelGV : Iterables.filter(securityLevels, (Predicate)namePredicate)) {
            filteredSecurityLevels.add(levelGV);
        }
        return filteredSecurityLevels;
    }

    private List<IssueSecurityLevel> filterSecurityLevelsByName(String securityLevelName, Collection<IssueSecurityLevel> securityLevels) {
        LinkedList<IssueSecurityLevel> filteredSecurityLevels = new LinkedList<IssueSecurityLevel>();
        for (IssueSecurityLevel issueSecurityLevel : securityLevels) {
            if (!issueSecurityLevel.getName().equals(securityLevelName)) continue;
            filteredSecurityLevels.add(issueSecurityLevel);
        }
        return filteredSecurityLevels;
    }

    private boolean levelExists(List<GenericValue> levels, Long id) {
        for (GenericValue level : levels) {
            if (!level.getLong("id").equals(id)) continue;
            return true;
        }
        return false;
    }

    public Long getSchemeDefaultSecurityLevel(GenericValue project) throws GenericEntityException {
        if (project != null) {
            GenericValue scheme = EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(project));
            return scheme == null ? null : scheme.getLong("defaultlevel");
        }
        return null;
    }

    public Long getDefaultSecurityLevel(Project project) {
        try {
            return this.getSchemeDefaultSecurityLevel(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue getIssueSecurityLevel(Long id) {
        return ComponentAccessor.getOfBizDelegator().findById("SchemeIssueSecurityLevels", id);
    }

    public void deleteSecurityLevel(Long levelId) {
        this.entityEngine.delete(Delete.from("SchemeIssueSecurities").whereEqual("security", levelId));
        this.entityEngine.delete(Delete.from(Entity.ISSUE_SECURITY_LEVEL).whereIdEquals(levelId));
    }

    public void clearUsersLevels() {
        this.projectAndUserToSecurityLevelCache.clear();
    }

    public void clearProjectLevels(GenericValue project) {
        Long projectId;
        if (project != null && (projectId = project.getLong("id")) != null) {
            Iterables.removeIf(this.projectAndUserToSecurityLevelCache.keySet(), (Predicate)new MatchesEntityId(projectId));
        }
    }

    private List<GenericValue> internSecurityLevelFields(List<GenericValue> list) {
        if (list != null) {
            for (GenericValue value : list) {
                this.internSecurityLevelFields(value);
            }
        }
        return list;
    }

    private GenericValue internSecurityLevelFields(GenericValue value) {
        EntityUtils.internStringFieldValue(value, "name");
        EntityUtils.internStringFieldValue(value, "description");
        return value;
    }

    static class CacheKey {
        final Long entityId;
        final User user;

        CacheKey(Long entityId, User user) {
            this.entityId = (Long)Assertions.notNull((String)"entityId", (Object)entityId);
            this.user = user;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.entityId.longValue() == other.entityId.longValue() && (this.user == null ? other.user == null : this.user.equals(other.user));
        }

        public int hashCode() {
            return this.entityId.hashCode() * 31 + (this.user != null ? this.user.hashCode() : 0);
        }

        public String toString() {
            return "CacheKey[entityId=" + this.entityId + ", user=" + (this.user != null ? this.user.getName() : "(null)") + ']';
        }
    }

    static class MatchesEntityId
    implements Predicate<CacheKey> {
        private final long entityId;

        MatchesEntityId(long entityId) {
            this.entityId = entityId;
        }

        public boolean apply(CacheKey input) {
            return input.entityId == this.entityId;
        }
    }

    static class SortByNameComparator
    implements Comparator<GenericValue> {
        static final SortByNameComparator INSTANCE = new SortByNameComparator();

        private SortByNameComparator() {
        }

        @Override
        public int compare(GenericValue level1, GenericValue level2) {
            String value1 = level1.getString("name");
            String value2 = level2.getString("name");
            return value1 == null ? (value2 == null ? 0 : 1) : (value2 == null ? -1 : value1.compareTo(value2));
        }
    }
}

